/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.BinaryOperator;
import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.Constants;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.MessageUtil;
import com.sun.faces.el.impl.PrimitiveObjects;
import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DivideOperator
extends BinaryOperator {
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.el.impl.DivideOperator";
    public static final DivideOperator SINGLETON = new DivideOperator();

    public String getOperatorSymbol() {
        return "/";
    }

    public Object apply(Object object, Object object2) throws ElException {
        if (object == null && object2 == null) {
            if (log.isLoggable(Level.WARNING)) {
                log.logp(Level.WARNING, CLASS_NAME, "apply", MessageUtil.getMessageWithArgs(Constants.ARITH_OP_NULL, this.getOperatorSymbol()));
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (Coercions.isBigDecimal(object) || Coercions.isBigInteger(object) || Coercions.isBigDecimal(object2) || Coercions.isBigInteger(object2)) {
            BigDecimal bigDecimal = (BigDecimal)Coercions.coerceToPrimitiveNumber(object, BigDecimal.class);
            BigDecimal bigDecimal2 = (BigDecimal)Coercions.coerceToPrimitiveNumber(object2, BigDecimal.class);
            try {
                return bigDecimal.divide(bigDecimal2, 4);
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.SEVERE)) {
                    String string = MessageUtil.getMessageWithArgs(Constants.ARITH_ERROR, this.getOperatorSymbol(), "" + bigDecimal, "" + bigDecimal2);
                    log.logp(Level.SEVERE, CLASS_NAME, "apply", string);
                    throw new ElException(string);
                }
                return PrimitiveObjects.getInteger(0);
            }
        }
        double d = Coercions.coerceToPrimitiveNumber(object, Double.class).doubleValue();
        double d2 = Coercions.coerceToPrimitiveNumber(object2, Double.class).doubleValue();
        try {
            return PrimitiveObjects.getDouble(d / d2);
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.SEVERE)) {
                String string = MessageUtil.getMessageWithArgs(Constants.ARITH_ERROR, this.getOperatorSymbol(), "" + d, "" + d2);
                log.logp(Level.SEVERE, CLASS_NAME, "apply", string);
                throw new ElException(string);
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

