/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.BinaryOperator;
import com.sun.faces.el.impl.Coercions;
import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.Expression;
import com.sun.faces.el.impl.ExpressionInfo;
import java.util.List;

public class BinaryOperatorExpression
extends Expression {
    Expression mExpression;
    List mOperators;
    List mExpressions;

    public Expression getExpression() {
        return this.mExpression;
    }

    public void setExpression(Expression expression) {
        this.mExpression = expression;
    }

    public List getOperators() {
        return this.mOperators;
    }

    public void setOperators(List list) {
        this.mOperators = list;
    }

    public List getExpressions() {
        return this.mExpressions;
    }

    public void setExpressions(List list) {
        this.mExpressions = list;
    }

    public BinaryOperatorExpression(Expression expression, List list, List list2) {
        this.mExpression = expression;
        this.mOperators = list;
        this.mExpressions = list2;
    }

    public String getExpressionString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.mExpression.getExpressionString());
        int n = this.mOperators.size();
        for (int i = 0; i < n; ++i) {
            BinaryOperator binaryOperator = (BinaryOperator)this.mOperators.get(i);
            Expression expression = (Expression)this.mExpressions.get(i);
            stringBuffer.append(" ");
            stringBuffer.append(binaryOperator.getOperatorSymbol());
            stringBuffer.append(" ");
            stringBuffer.append(expression.getExpressionString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Object evaluate(ExpressionInfo expressionInfo) throws ElException {
        Object object = this.mExpression.evaluate(expressionInfo);
        int n = this.mOperators.size();
        for (int i = 0; i < n; ++i) {
            BinaryOperator binaryOperator = (BinaryOperator)this.mOperators.get(i);
            if (binaryOperator.shouldCoerceToBoolean()) {
                object = Coercions.coerceToBoolean(object);
            }
            if (!binaryOperator.shouldEvaluate(object)) continue;
            Expression expression = (Expression)this.mExpressions.get(i);
            Object object2 = expression.evaluate(expressionInfo);
            object = binaryOperator.apply(object, object2);
        }
        return object;
    }
}

