/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

public class FacesContextImpl
extends FacesContext {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.context.FacesContextImpl";
    private boolean released;
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private ExternalContext externalContext = null;
    private Application application = null;
    private UIViewRoot viewRoot = null;
    private Map componentMessageLists;
    private boolean renderResponse = false;
    private boolean responseComplete = false;

    public FacesContextImpl() {
    }

    public FacesContextImpl(ExternalContext externalContext, Lifecycle lifecycle) {
        if (null == externalContext || null == lifecycle) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        this.externalContext = externalContext;
        FacesContextImpl.setCurrentInstance((FacesContext)this);
    }

    public ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this.externalContext;
    }

    public Application getApplication() {
        this.assertNotReleased();
        if (null != this.application) {
            return this.application;
        }
        ApplicationFactory applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = applicationFactory.getApplication();
        Util.doAssert(null != this.application);
        return this.application;
    }

    public Iterator getClientIdsWithMessages() {
        this.assertNotReleased();
        Iterator<Object> iterator = null;
        iterator = null == this.componentMessageLists ? Collections.EMPTY_LIST.iterator() : this.componentMessageLists.keySet().iterator();
        return iterator;
    }

    public Iterator getFacesEvents() {
        this.assertNotReleased();
        return Collections.EMPTY_LIST.iterator();
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        int n = 0;
        FacesMessage.Severity severity = null;
        if (null == this.componentMessageLists) {
            return null;
        }
        List list = this.getMergedMessageLists();
        int n2 = this.getMergedMessageLists().size();
        for (int i = 0; i < n2; ++i) {
            severity = ((FacesMessage)list.get(i)).getSeverity();
            if (severity.getOrdinal() > n) {
                n = severity.getOrdinal();
            }
            if (severity == FacesMessage.SEVERITY_FATAL) break;
        }
        return severity;
    }

    public Iterator getMessages() {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.EMPTY_LIST.iterator();
        }
        List list = this.getMergedMessageLists();
        if (list.size() > 0) {
            return list.iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getMessages(String string) {
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            return Collections.EMPTY_LIST.iterator();
        }
        List list = (List)this.componentMessageLists.get(string);
        if (list == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return list.iterator();
    }

    public RenderKit getRenderKit() {
        this.assertNotReleased();
        UIViewRoot uIViewRoot = this.getViewRoot();
        if (uIViewRoot == null) {
            return null;
        }
        String string = uIViewRoot.getRenderKitId();
        if (string == null) {
            return null;
        }
        RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return renderKitFactory.getRenderKit((FacesContext)this, string);
    }

    public ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.assertNotReleased();
        if (responseStream == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_RESPONSE_STREAM_ERROR"));
        }
        this.responseStream = responseStream;
    }

    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot uIViewRoot) {
        this.assertNotReleased();
        this.viewRoot = uIViewRoot;
    }

    public ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.assertNotReleased();
        if (responseWriter == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_RESPONSE_WRITER_ERROR"));
        }
        this.responseWriter = responseWriter;
    }

    public void addFacesEvent(FacesEvent facesEvent) {
        this.assertNotReleased();
        if (facesEvent == null) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_EVENT_ERROR"));
        }
        if (log.isLoggable(Level.FINE)) {
            String string = facesEvent.getComponent().getId();
            if (string == null) {
                string = "<<NONE>>";
            }
            log.logp(Level.FINE, CLASS_NAME, "addFacesEvent", "Adding FacesEvent[sourceId=" + string + ",type=" + facesEvent.getClass().getName());
        }
    }

    public void addMessage(String string, FacesMessage facesMessage) {
        ArrayList<FacesMessage> arrayList;
        this.assertNotReleased();
        if (null == facesMessage) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (this.componentMessageLists == null) {
            this.componentMessageLists = new HashMap();
        }
        if ((arrayList = (ArrayList<FacesMessage>)this.componentMessageLists.get(string)) == null) {
            arrayList = new ArrayList<FacesMessage>();
            this.componentMessageLists.put(string, arrayList);
        }
        arrayList.add(facesMessage);
        Level level = Level.FINE;
        if (facesMessage.getSeverity() != null) {
            if (facesMessage.getSeverity().compareTo((Object)FacesMessage.SEVERITY_INFO) == 0) {
                level = Level.INFO;
            } else if (facesMessage.getSeverity().compareTo((Object)FacesMessage.SEVERITY_ERROR) == 0) {
                level = Level.SEVERE;
            } else if (facesMessage.getSeverity().compareTo((Object)FacesMessage.SEVERITY_FATAL) == 0) {
                level = Level.SEVERE;
            } else if (facesMessage.getSeverity().compareTo((Object)FacesMessage.SEVERITY_WARN) == 0) {
                level = Level.WARNING;
            }
        }
        if (log.isLoggable(level)) {
            log.logp(level, CLASS_NAME, "addMessage", "Adding Message[sourceId=" + (string != null ? string : "<<NONE>>") + ",summary=" + facesMessage.getSummary() + ")");
        }
    }

    public void release() {
        this.released = true;
        this.externalContext = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.componentMessageLists = null;
        this.renderResponse = false;
        this.responseComplete = false;
        this.viewRoot = null;
        FacesContextImpl.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.assertNotReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.assertNotReleased();
        this.responseComplete = true;
    }

    public boolean getRenderResponse() {
        this.assertNotReleased();
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        this.assertNotReleased();
        return this.responseComplete;
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    private List getMergedMessageLists() {
        ArrayList arrayList = new ArrayList();
        if (this.componentMessageLists != null) {
            Iterator iterator = this.componentMessageLists.values().iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((ArrayList)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    arrayList.add(iterator2.next());
                }
            }
        }
        return arrayList;
    }
}

