/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigFeature;
import com.sun.faces.config.ConfigManagedBeanProperty;
import com.sun.faces.config.ConfigManagedBeanPropertyValue;
import com.sun.faces.config.ConfigManagedPropertyMap;
import com.sun.faces.util.Util;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

public class ConfigManagedBean
extends ConfigFeature
implements Cloneable {
    protected static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "ConfigManagedBean";
    private String managedBeanId;
    private String managedBeanClass;
    private String managedBeanScope;
    private String managedBeanCreate;
    private ConfigManagedBeanProperty listOrMap;
    private HashMap properties = null;

    public String getManagedBeanId() {
        return this.managedBeanId;
    }

    public void setManagedBeanId(String string) {
        this.managedBeanId = string;
    }

    public String getManagedBeanClass() {
        return this.managedBeanClass;
    }

    public void setManagedBeanClass(String string) {
        this.managedBeanClass = string;
    }

    public String getManagedBeanScope() {
        return this.managedBeanScope;
    }

    public void setManagedBeanScope(String string) {
        this.managedBeanScope = string;
    }

    public String getManagedBeanCreate() {
        return this.managedBeanCreate;
    }

    public void setManagedBeanCreate(String string) {
        this.managedBeanCreate = string;
    }

    public void setListOrMap(ConfigManagedBeanProperty configManagedBeanProperty) throws FacesException {
        this.listOrMap = configManagedBeanProperty;
    }

    public ConfigManagedBeanProperty getListOrMap() {
        return this.listOrMap;
    }

    public void addProperty(ConfigManagedBeanProperty configManagedBeanProperty) throws FacesException {
        Class clazz;
        if (null == configManagedBeanProperty) {
            throw new NullPointerException(Util.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR"));
        }
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((clazz = this.getPropertyType(configManagedBeanProperty)) != null) {
            configManagedBeanProperty.convertValue(ConfigManagedBean.replaceIfPrimitive(clazz));
        }
        this.properties.put(configManagedBeanProperty.getPropertyName(), configManagedBeanProperty);
    }

    public Map getProperties() {
        if (this.properties == null) {
            return Collections.EMPTY_MAP;
        }
        return this.properties;
    }

    public Object clone() {
        ConfigManagedBean configManagedBean = null;
        try {
            configManagedBean = (ConfigManagedBean)super.clone();
            if (this.properties != null) {
                configManagedBean.properties = (HashMap)this.properties.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return configManagedBean;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ID:" + this.getManagedBeanId() + "\nCLASS:" + this.getManagedBeanClass() + "\nSCOPE:" + this.getManagedBeanScope() + "\nCREATE:" + this.getManagedBeanCreate() + "\nPROPERTIES...");
        if (this.properties.size() > 0) {
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Cloneable cloneable;
                int n;
                int n2;
                Object object;
                String string = (String)iterator.next();
                ConfigManagedBeanProperty configManagedBeanProperty = (ConfigManagedBeanProperty)this.properties.get(string);
                String string2 = configManagedBeanProperty.getPropertyName();
                stringBuffer.append("\n    NAME:" + configManagedBeanProperty.getPropertyName());
                if (configManagedBeanProperty.hasValuesArray()) {
                    stringBuffer.append("\n    VALUES:");
                    object = configManagedBeanProperty.getValues();
                    n2 = object.size();
                    for (n = 0; n < n2; ++n) {
                        cloneable = (ConfigManagedBeanPropertyValue)object.get(n);
                        stringBuffer.append("\n      VALUE:CATEGORY:" + ((ConfigManagedBeanPropertyValue)cloneable).getValueCategory() + " : VALUE:" + ((ConfigManagedBeanPropertyValue)cloneable).getValue());
                    }
                    continue;
                }
                if (configManagedBeanProperty.hasMapEntries()) {
                    stringBuffer.append("\n    MAP KEY CLASS:" + configManagedBeanProperty.getMapKeyClass());
                    stringBuffer.append("\n    MAP VALUE CLASS:" + configManagedBeanProperty.getMapValueClass());
                    stringBuffer.append("\n    MAP ENTRIES:");
                    object = configManagedBeanProperty.getMapEntries();
                    n2 = object.size();
                    for (n = 0; n < n2; ++n) {
                        cloneable = (ConfigManagedPropertyMap)object.get(n);
                        stringBuffer.append("\n      KEY:" + ((ConfigManagedPropertyMap)cloneable).getKey() + " : VALUE:CATEGORY:" + ((ConfigManagedPropertyMap)cloneable).getValueCategory() + " : VALUE:" + ((ConfigManagedPropertyMap)cloneable).getValue());
                    }
                    continue;
                }
                object = configManagedBeanProperty.getValue();
                stringBuffer.append("\n    VALUE:CATEGORY:" + ((ConfigManagedBeanPropertyValue)object).getValueCategory() + " : VALUE:" + ((ConfigManagedBeanPropertyValue)object).getValue());
            }
        }
        return stringBuffer.toString();
    }

    private Class getPropertyType(ConfigManagedBeanProperty configManagedBeanProperty) {
        boolean bl = false;
        Class<?> clazz = null;
        Class clazz2 = null;
        if (!configManagedBeanProperty.hasValuesArray() && !configManagedBeanProperty.hasMapEntries()) {
            int n;
            Object object;
            PropertyDescriptor[] propertyDescriptorArray = null;
            try {
                clazz2 = Util.loadClass(this.managedBeanClass, this);
                object = Introspector.getBeanInfo(clazz2);
                propertyDescriptorArray = object.getPropertyDescriptors();
            }
            catch (ClassNotFoundException classNotFoundException) {
                Object[] objectArray = new Object[]{this.managedBeanClass};
                String string = Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray);
                if (log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "getPropertyType", string, classNotFoundException);
                }
                throw new FacesException(string, (Throwable)classNotFoundException);
            }
            catch (IntrospectionException introspectionException) {
                if (this.isUIComponentClass(clazz2)) {
                    return null;
                }
                Object[] objectArray = new Object[]{this.managedBeanClass};
                String string = Util.getExceptionMessageString("com.sun.faces.CANT_INTROSPECT_CLASS", objectArray);
                if (log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "getPropertyType", string, introspectionException);
                }
                throw new FacesException(string, (Throwable)introspectionException);
            }
            object = null;
            for (n = 0; n < propertyDescriptorArray.length; ++n) {
                if (!configManagedBeanProperty.getPropertyName().equals(propertyDescriptorArray[n].getName())) continue;
                object = propertyDescriptorArray[n];
                break;
            }
            if (object == null) {
                if (this.isUIComponentClass(clazz2)) {
                    return null;
                }
                Object[] objectArray = new Object[]{this.managedBeanClass};
                String string = Util.getExceptionMessageString("com.sun.faces.CANT_INTROSPECT_CLASS", objectArray);
                if (log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "getPropertyType", string);
                }
                throw new FacesException(string);
            }
            if (object instanceof IndexedPropertyDescriptor) {
                n = 1;
                clazz = ((IndexedPropertyDescriptor)object).getIndexedPropertyType();
            } else {
                n = 0;
                clazz = ((PropertyDescriptor)object).getPropertyType();
            }
        }
        return clazz;
    }

    public boolean isUIComponentClass(Class clazz) {
        Class clazz2 = null;
        try {
            clazz2 = Util.loadClass("javax.faces.component.UIComponent", this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray = new Object[]{clazz2};
            String string = Util.getExceptionMessageString("com.sun.faces.CANT_INSTANTIATE_CLASS", objectArray);
            if (log.isLoggable(Level.WARNING)) {
                log.logp(Level.WARNING, CLASS_NAME, "isUIComponentClass", string, classNotFoundException);
            }
            throw new FacesException(string, (Throwable)classNotFoundException);
        }
        return clazz2.isAssignableFrom(clazz);
    }

    private static Class replaceIfPrimitive(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (clazz.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (clazz.equals(Character.TYPE)) {
            return Character.class;
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.class;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.class;
        }
        if (clazz.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.class;
        }
        if (clazz.equals(Short.TYPE)) {
            return Short.class;
        }
        return clazz;
    }
}

