/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.TreeStructure;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class StateManagerImpl
extends StateManager {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.sun.faces.application.StateManagerImpl";
    private static final String NUMBER_OF_VIEWS_IN_SESSION = "com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 15;
    private static final String FACES_VIEW_LIST = "com.sun.faces.VIEW_LIST";
    int noOfViews = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateManager.SerializedView saveSerializedView(FacesContext facesContext) throws IllegalStateException {
        StateManager.SerializedView serializedView = null;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (uIViewRoot.isTransient()) {
            return serializedView;
        }
        if (!this.isSavingStateInClient(facesContext)) {
            this.removeTransientChildrenAndFacets(facesContext, (UIComponent)uIViewRoot, new HashSet());
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "Saving view in session for viewId " + uIViewRoot.getViewId());
            }
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                Map map = Util.getSessionMap(facesContext);
                ArrayList<String> arrayList = (ArrayList<String>)map.get(FACES_VIEW_LIST);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                if (arrayList.contains(uIViewRoot.getViewId())) {
                    arrayList.remove(uIViewRoot.getViewId());
                }
                arrayList.add(uIViewRoot.getViewId());
                map.put(uIViewRoot.getViewId(), uIViewRoot);
                map.put(FACES_VIEW_LIST, arrayList);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "Begin creating serialized view for " + uIViewRoot.getViewId());
            }
            serializedView = new StateManager.SerializedView((StateManager)this, this.getTreeStructureToSave(facesContext), this.getComponentStateToSave(facesContext));
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "saveSerializedView", "End creating serialized view " + uIViewRoot.getViewId());
            }
        }
        return serializedView;
    }

    protected void removeTransientChildrenAndFacets(FacesContext facesContext, UIComponent uIComponent, Set set) {
        String string;
        UIComponent uIComponent2;
        Iterator<Object> iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            uIComponent2 = (UIComponent)iterator.next();
            if (null != uIComponent2.getId() && (string = uIComponent2.getClientId(facesContext)) != null && !set.add(string)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{string}));
            }
            if (uIComponent2.isTransient()) {
                iterator.remove();
                continue;
            }
            this.removeTransientChildrenAndFacets(facesContext, uIComponent2, set);
        }
        iterator = uIComponent.getFacets().values().iterator();
        while (iterator.hasNext()) {
            uIComponent2 = (UIComponent)iterator.next();
            if (null != uIComponent2.getId() && (string = uIComponent2.getClientId(facesContext)) != null && !set.add(string)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{string}));
            }
            if (uIComponent2.isTransient()) {
                iterator.remove();
                continue;
            }
            this.removeTransientChildrenAndFacets(facesContext, uIComponent2, set);
        }
    }

    protected Object getComponentStateToSave(FacesContext facesContext) {
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        return uIViewRoot.processSaveState(facesContext);
    }

    protected Object getTreeStructureToSave(FacesContext facesContext) {
        TreeStructure treeStructure = null;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        if (!uIViewRoot.isTransient()) {
            treeStructure = new TreeStructure((UIComponent)uIViewRoot);
            this.buildTreeStructureToSave(facesContext, (UIComponent)uIViewRoot, treeStructure, null);
        }
        return treeStructure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UIViewRoot restoreView(FacesContext facesContext, String string, String string2) {
        if (null == string2) {
            throw new IllegalArgumentException();
        }
        UIViewRoot uIViewRoot = null;
        if (this.isSavingStateInClient(facesContext)) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "restoreView", "Begin restoring view from response " + string);
            }
            if ((uIViewRoot = this.restoreTreeStructure(facesContext, string, string2)) != null) {
                this.restoreComponentState(facesContext, uIViewRoot, string2);
            } else if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "restoreView", "Possibly a new request. Tree structure could not be restored for " + string);
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "restoreView", "End restoring view from response " + string);
            }
        } else {
            Map map = Util.getSessionMap(facesContext);
            StateManagerImpl stateManagerImpl = this;
            synchronized (stateManagerImpl) {
                uIViewRoot = (UIViewRoot)map.get(string);
                if (uIViewRoot != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "restoreView", "Restoring view from session for viewId " + string);
                    }
                    this.removeViewFromSession(facesContext, uIViewRoot);
                } else if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "restoreView", "View from session for viewId " + string + " does not exist.");
                }
            }
        }
        return uIViewRoot;
    }

    private void removeViewFromSession(FacesContext facesContext, UIViewRoot uIViewRoot) {
        String string;
        ArrayList arrayList;
        Map map;
        block7: {
            map = Util.getSessionMap(facesContext);
            arrayList = (ArrayList)map.get(FACES_VIEW_LIST);
            if (arrayList == null) {
                return;
            }
            if (this.noOfViews == 0) {
                this.noOfViews = 15;
                string = facesContext.getExternalContext().getInitParameter(NUMBER_OF_VIEWS_IN_SESSION);
                if (string != null) {
                    try {
                        this.noOfViews = Integer.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.noOfViews = 15;
                        if (!log.isLoggable(Level.FINE)) break block7;
                        log.logp(Level.FINE, CLASS_NAME, "removeViewFromSession", "Error parsing the servetInitParameter com.sun.faces.NUMBER_OF_VIEWS_IN_SESSION. Using the default " + this.noOfViews);
                    }
                }
            }
        }
        if (arrayList.size() > this.noOfViews) {
            string = (String)arrayList.remove(0);
            map.remove(string);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "removeViewFromSession", "Number of views in session exceeded specified number " + this.noOfViews + ".Removing view " + string);
            }
        }
    }

    protected void restoreComponentState(FacesContext facesContext, UIViewRoot uIViewRoot, String string) {
        if (null == string) {
            throw new IllegalArgumentException();
        }
        Object object = Util.getResponseStateManager(facesContext, string).getComponentStateToRestore(facesContext);
        uIViewRoot.processRestoreState(facesContext, object);
    }

    protected UIViewRoot restoreTreeStructure(FacesContext facesContext, String string, String string2) {
        if (null == string2) {
            throw new IllegalArgumentException();
        }
        UIComponent uIComponent = null;
        TreeStructure treeStructure = null;
        treeStructure = (TreeStructure)Util.getResponseStateManager(facesContext, string2).getTreeStructureToRestore(facesContext, string);
        if (treeStructure == null) {
            return null;
        }
        uIComponent = treeStructure.createComponent();
        this.restoreComponentTreeStructure(treeStructure, uIComponent);
        return (UIViewRoot)uIComponent;
    }

    public void writeState(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (this.isSavingStateInClient(facesContext)) {
            Util.getResponseStateManager(facesContext, facesContext.getViewRoot().getRenderKitId()).writeState(facesContext, serializedView);
        }
    }

    public void buildTreeStructureToSave(FacesContext facesContext, UIComponent uIComponent, TreeStructure treeStructure, Set hashSet) {
        Object object;
        String string;
        Object object2;
        if (null == hashSet) {
            hashSet = new HashSet<String>();
        }
        Iterator iterator = uIComponent.getChildren().iterator();
        while (iterator.hasNext()) {
            object2 = (UIComponent)iterator.next();
            if (null != object2.getId() && (string = object2.getClientId(facesContext)) != null && !hashSet.add(string)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{string}));
            }
            if (object2.isTransient()) continue;
            object = new TreeStructure((UIComponent)object2);
            treeStructure.addChild((TreeStructure)object);
            this.buildTreeStructureToSave(facesContext, (UIComponent)object2, (TreeStructure)object, hashSet);
        }
        object2 = uIComponent.getFacets().keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            UIComponent uIComponent2 = (UIComponent)uIComponent.getFacets().get(object);
            if (null != uIComponent2.getId() && (string = uIComponent2.getClientId(facesContext)) != null && !hashSet.add(string)) {
                throw new IllegalStateException(Util.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", new Object[]{string}));
            }
            if (uIComponent2.isTransient()) continue;
            TreeStructure treeStructure2 = new TreeStructure(uIComponent2);
            treeStructure.addFacet((String)object, treeStructure2);
            this.buildTreeStructureToSave(facesContext, uIComponent2, treeStructure2, hashSet);
        }
    }

    public void restoreComponentTreeStructure(TreeStructure treeStructure, UIComponent uIComponent) {
        Object object;
        Object object2;
        Iterator iterator = treeStructure.getChildren();
        while (iterator.hasNext()) {
            object2 = (TreeStructure)iterator.next();
            object = ((TreeStructure)object2).createComponent();
            uIComponent.getChildren().add(object);
            this.restoreComponentTreeStructure((TreeStructure)object2, (UIComponent)object);
        }
        object2 = treeStructure.getFacetNames();
        while (object2.hasNext()) {
            object = (String)object2.next();
            TreeStructure treeStructure2 = treeStructure.getTreeStructureForFacet((String)object);
            UIComponent uIComponent2 = treeStructure2.createComponent();
            uIComponent.getFacets().put(object, uIComponent2);
            this.restoreComponentTreeStructure(treeStructure2, uIComponent2);
        }
    }
}

