/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.extprocessor;

import com.ibm.ws.jsf.JSFConstants;
import com.ibm.ws.jsf.configuration.FacesConfig;
import com.ibm.ws.jsf.extprocessor.JSFExtensionProcessor;
import com.ibm.ws.jsf.util.JspURIMatcher;
import com.ibm.ws.webcontainer.servlet.ServletConfig;
import com.ibm.ws.webcontainer.servlet.ServletMapping;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import com.sun.faces.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class JSFExtensionFactory
implements ExtensionFactory {
    protected static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.extprocessor.JSFExtensionFactory";
    private static String FACES_SERVLET_PACKAGE = "javax.faces.webapp.FacesServlet";
    private static String FACES_SERVLET_RESOURCE = "javax/faces/webapp/FacesServlet.class";
    private URL defaultFacesServlet = Util.getCurrentLoader(this).getResource(FACES_SERVLET_RESOURCE);

    public ExtensionProcessor createExtensionProcessor(IServletContext iServletContext) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Enter createExtensionProcessor(): webapp =[" + iServletContext.getServletContextName() + "]");
        }
        URL uRL = null;
        if (System.getSecurityManager() != null) {
            final IServletContext iServletContext2 = iServletContext;
            uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return iServletContext2.getClassLoader().getResource(FACES_SERVLET_RESOURCE);
                }
            });
        } else {
            uRL = iServletContext.getClassLoader().getResource(FACES_SERVLET_RESOURCE);
        }
        boolean bl = false;
        if (!this.defaultFacesServlet.equals(uRL)) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Application overrode default Faces Servlet. Default WebSphere JSF config will be ignored.");
            }
        } else {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>(11);
            WebAppConfig webAppConfig = iServletContext.getWebAppConfig();
            Object object2 = webAppConfig.getServletInfos();
            while (object2.hasNext()) {
                object = (ServletConfig)object2.next();
                String string = object.getClassName();
                if (string == null || !string.equals(FACES_SERVLET_PACKAGE)) continue;
                bl = true;
                List list = object.getMappings();
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ServletMapping servletMapping = (ServletMapping)iterator.next();
                        String string2 = this.massagePattern(servletMapping.getUrlPattern());
                        arrayList.add(string2);
                    }
                }
                if (!log.isLoggable(Level.FINE)) continue;
                log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Located " + FACES_SERVLET_PACKAGE + " with mappings=[" + arrayList + "]");
            }
            if (arrayList.isEmpty() && log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Did not locate " + FACES_SERVLET_PACKAGE + " with mappings in web.xml");
            }
            iServletContext.setAttribute(JSFConstants.FACES_SERVLET_MAPPINGS, arrayList);
            object2 = iServletContext.getInitParameter(JSFConstants.JSP_UPDATE_CHECK);
            if (object2 != null && ((String)object2).equalsIgnoreCase("TRUE")) {
                object = new JspURIMatcher(iServletContext);
                iServletContext.setAttribute(JSFConstants.JSP_URI_MATCHER, object);
            }
            object = new FacesConfig();
            object.initialize((ServletContext)iServletContext, bl);
        }
        return new JSFExtensionProcessor(iServletContext);
    }

    public List getPatternList() {
        return Collections.EMPTY_LIST;
    }

    private String massagePattern(String string) {
        if (string.charAt(0) == '*') {
            string = string.substring(1);
        } else if (string.endsWith("/*")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }
}

