/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.configuration;

import com.ibm.ws.jsf.JSFConstants;
import com.ibm.ws.jsf.util.FacesConfigUtil;
import com.sun.faces.RIConstants;
import com.sun.faces.util.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public final class FacesConfig {
    private static Set loaders = new HashSet();
    private static Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.config.FacesConfig";

    public void initialize(ServletContext servletContext, boolean bl) {
        String string;
        boolean bl2;
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "initialize", "Servlet context name(" + servletContext.getServletContextName() + ")");
        }
        if (this.initialized()) {
            return;
        }
        String string2 = null;
        string2 = servletContext.getInitParameter("com.sun.faces.enableHtmlTagLibValidator");
        if (null != string2) {
            if (string2.toString().equals("true")) {
                RIConstants.setHtmlTagLibValidatorActive(true);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initialize", "Webmodule enabled Html tag library validation");
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initialize", "Webmodule disabled Html Tag Library validation [" + string2.toString() + "]");
            }
        }
        if ((bl2 = new Boolean(string = servletContext.getInitParameter(JSFConstants.LOAD_FACES_CONFIG_STARTUP)).booleanValue()) || bl) {
            if (null == servletContext.getAttribute("com.sun.faces.OneTimeInitialization")) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initialize", "Webmodule requested config to be loaded at startup or defined FacesServlet mapping in web.xml.");
                }
                Util.verifyFactoriesAndInitDefaultRenderKit(servletContext);
            } else if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initialize", "Configuration already loaded for this webmodule");
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initialize", "Create default factories. Delay loading of JSF config to first request.");
            }
            FacesConfigUtil.createDefaultJSFFactories();
        }
        servletContext.setAttribute("com.sun.faces.ConfigBase", (Object)Boolean.TRUE);
    }

    public void destroy(ServletContext servletContext) {
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "destroy", "Servlet context name(" + servletContext.getServletContextName() + ")");
        }
        servletContext.removeAttribute("com.sun.faces.ConfigBase");
        this.release();
        Util.releaseFactoriesAndDefaultRenderKit(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initialized() {
        ClassLoader classLoader = Util.getCurrentLoader(this);
        Set set = loaders;
        synchronized (set) {
            if (!loaders.contains(classLoader)) {
                loaders.add(classLoader);
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initialized", "Initializing this webapp");
                }
                return false;
            }
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initialized", "Listener already completed for this webapp");
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        ClassLoader classLoader = Util.getCurrentLoader(this);
        Set set = loaders;
        synchronized (set) {
            loaders.remove(classLoader);
        }
    }
}

