/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import sun.security.provider.PolicyParser;
import sun.security.tools.LegacyList;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyTool;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindow;

class EditPolicyPrinOKButtonListener
implements ActionListener {
    private PolicyTool tool;
    private ToolWindow tw;
    private ToolDialog listDialog;
    private ToolDialog infoDialog;
    private boolean edit;

    EditPolicyPrinOKButtonListener(PolicyTool policyTool, ToolWindow toolWindow, ToolDialog toolDialog, ToolDialog toolDialog2, boolean bl) {
        this.tool = policyTool;
        this.tw = toolWindow;
        this.listDialog = toolDialog;
        this.infoDialog = toolDialog2;
        this.edit = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            PolicyParser.PrincipalEntry principalEntry = this.infoDialog.getPrinFromDialog();
            if (principalEntry != null) {
                try {
                    this.tool.verifyPrincipal(principalEntry);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.tool.warnings.addElement(PolicyTool.rb.getString("Warning: Class not found: ") + principalEntry.getPrincipalClass());
                    this.tw.displayStatusDialog(this.infoDialog, PolicyTool.rb.getString("Warning: Class not found: ") + principalEntry.getPrincipalClass());
                }
                LegacyList legacyList = (LegacyList)this.tw.getContentPane().getComponent(5);
                int n = legacyList.getSelectedIndex();
                PolicyEntry[] policyEntryArray = this.tool.getEntry();
                PolicyEntry policyEntry = policyEntryArray[n];
                LegacyList legacyList2 = (LegacyList)this.listDialog.getContentPane().getComponent(6);
                boolean bl = false;
                bl = this.edit ? this.tool.addPrinEntry(policyEntry, principalEntry, legacyList2.getSelectedIndex()) : this.tool.addPrinEntry(policyEntry, principalEntry, -1);
                if (bl) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    principalEntry.write(printWriter);
                    String string = stringWriter.toString();
                    if (this.edit) {
                        legacyList2.replaceItem(string, legacyList2.getSelectedIndex());
                    } else {
                        legacyList2.add(string);
                    }
                }
            }
            this.infoDialog.dispose();
        }
        catch (Exception exception) {
            this.tw.displayErrorDialog(this.infoDialog, PolicyTool.rb.getString("Operation failed due to unexpected exception: ") + exception);
        }
    }
}

