/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.Permission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.security.util.ResourcesMgr;

class SelfPermission
extends Permission {
    static final long serialVersionUID = -8315562579967246806L;
    private String type;
    private String name;
    private String actions;
    private Certificate[] certs;

    public SelfPermission(String string, String string2, String string3, Certificate[] certificateArray) {
        super(string);
        if (string == null) {
            throw new NullPointerException(ResourcesMgr.getString("type can't be null"));
        }
        this.type = string;
        this.name = string2;
        this.actions = string3;
        if (certificateArray != null) {
            int n;
            for (n = 0; n < certificateArray.length; ++n) {
                if (certificateArray[n] instanceof X509Certificate) continue;
                this.certs = (Certificate[])certificateArray.clone();
                break;
            }
            if (this.certs == null) {
                int n2 = 0;
                for (n = 0; n < certificateArray.length; ++n) {
                    ++n2;
                    while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                        ++n;
                    }
                }
                if (n2 == certificateArray.length) {
                    this.certs = (Certificate[])certificateArray.clone();
                }
                if (this.certs == null) {
                    ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
                    for (n = 0; n < certificateArray.length; ++n) {
                        arrayList.add(certificateArray[n]);
                        while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                            ++n;
                        }
                    }
                    this.certs = new Certificate[arrayList.size()];
                    arrayList.toArray(this.certs);
                }
            }
        }
    }

    public boolean implies(Permission permission) {
        return false;
    }

    public boolean equals(Object object) {
        int n;
        boolean bl;
        int n2;
        if (object == this) {
            return true;
        }
        if (!(object instanceof SelfPermission)) {
            return false;
        }
        SelfPermission selfPermission = (SelfPermission)object;
        if (!(this.type.equals(selfPermission.type) && this.name.equals(selfPermission.name) && this.actions.equals(selfPermission.actions))) {
            return false;
        }
        if (this.certs.length != selfPermission.certs.length) {
            return false;
        }
        for (n2 = 0; n2 < this.certs.length; ++n2) {
            bl = false;
            for (n = 0; n < selfPermission.certs.length; ++n) {
                if (!this.certs[n2].equals(selfPermission.certs[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        for (n2 = 0; n2 < selfPermission.certs.length; ++n2) {
            bl = false;
            for (n = 0; n < this.certs.length; ++n) {
                if (!selfPermission.certs[n2].equals(this.certs[n])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = this.type.hashCode();
        if (this.name != null) {
            n ^= this.name.hashCode();
        }
        if (this.actions != null) {
            n ^= this.actions.hashCode();
        }
        return n;
    }

    public String getActions() {
        return "";
    }

    public String getSelfType() {
        return this.type;
    }

    public String getSelfName() {
        return this.name;
    }

    public String getSelfActions() {
        return this.actions;
    }

    public Certificate[] getCerts() {
        return this.certs;
    }

    public String toString() {
        return "(SelfPermission " + this.type + " " + this.name + " " + this.actions + ")";
    }
}

