/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import sun.security.pkcs.PKCS9Attribute;

public class PKCS9Attributes {
    private final Hashtable attributes = new Hashtable(3);
    private final Hashtable permittedAttributes;
    private final byte[] derEncoding;

    public PKCS9Attributes(ObjectIdentifier[] objectIdentifierArray, DerInputStream derInputStream) throws IOException {
        if (objectIdentifierArray != null) {
            this.permittedAttributes = new Hashtable(objectIdentifierArray.length);
            for (int i = 0; i < objectIdentifierArray.length; ++i) {
                this.permittedAttributes.put(objectIdentifierArray[i], objectIdentifierArray[i]);
            }
        } else {
            this.permittedAttributes = null;
        }
        this.derEncoding = this.decode(derInputStream);
    }

    public PKCS9Attributes(DerInputStream derInputStream) throws IOException {
        this.derEncoding = this.decode(derInputStream);
        this.permittedAttributes = null;
    }

    public PKCS9Attributes(PKCS9Attribute[] pKCS9AttributeArray) throws IllegalArgumentException, IOException {
        for (int i = 0; i < pKCS9AttributeArray.length; ++i) {
            ObjectIdentifier objectIdentifier = pKCS9AttributeArray[i].getOID();
            if (this.attributes.containsKey(objectIdentifier)) {
                throw new IllegalArgumentException("PKCSAttribute " + pKCS9AttributeArray[i].getOID() + " duplicated while constructing " + "PKCS9Attributes.");
            }
            this.attributes.put(objectIdentifier, pKCS9AttributeArray[i]);
        }
        this.derEncoding = this.generateDerEncoding();
        this.permittedAttributes = null;
    }

    private byte[] decode(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        byte[] byArray = derValue.toByteArray();
        byArray[0] = 49;
        DerInputStream derInputStream2 = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream2.getSet(3, true);
        for (int i = 0; i < derValueArray.length; ++i) {
            PKCS9Attribute pKCS9Attribute = new PKCS9Attribute(derValueArray[i]);
            ObjectIdentifier objectIdentifier = pKCS9Attribute.getOID();
            if (this.attributes.get(objectIdentifier) != null) {
                throw new IOException("Duplicate PKCS9 attribute: " + objectIdentifier);
            }
            if (this.permittedAttributes != null && !this.permittedAttributes.containsKey(objectIdentifier)) {
                throw new IOException("Attribute " + objectIdentifier + " not permitted in this attribute set");
            }
            this.attributes.put(objectIdentifier, pKCS9Attribute);
        }
        return byArray;
    }

    public void encode(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
        outputStream.write(this.derEncoding, 1, this.derEncoding.length - 1);
    }

    private byte[] generateDerEncoding() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        Object[] objectArray = this.attributes.values().toArray();
        derOutputStream.putOrderedSetOf((byte)49, PKCS9Attributes.castToDerEncoder(objectArray));
        return derOutputStream.toByteArray();
    }

    public byte[] getDerEncoding() throws IOException {
        return (byte[])this.derEncoding.clone();
    }

    public PKCS9Attribute getAttribute(ObjectIdentifier objectIdentifier) {
        return (PKCS9Attribute)this.attributes.get(objectIdentifier);
    }

    public PKCS9Attribute getAttribute(String string) {
        return (PKCS9Attribute)this.attributes.get(PKCS9Attribute.getOID(string));
    }

    public PKCS9Attribute[] getAttributes() {
        PKCS9Attribute[] pKCS9AttributeArray = new PKCS9Attribute[this.attributes.size()];
        int n = 0;
        for (int i = 1; i < PKCS9Attribute.PKCS9_OIDS.length && n < pKCS9AttributeArray.length; ++i) {
            pKCS9AttributeArray[n] = this.getAttribute(PKCS9Attribute.PKCS9_OIDS[i]);
            if (pKCS9AttributeArray[n] == null) continue;
            ++n;
        }
        return pKCS9AttributeArray;
    }

    public Object getAttributeValue(ObjectIdentifier objectIdentifier) throws IOException {
        try {
            Object object = this.getAttribute(objectIdentifier).getValue();
            return object;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("No value found for attribute " + objectIdentifier);
        }
    }

    public Object getAttributeValue(String string) throws IOException {
        ObjectIdentifier objectIdentifier = PKCS9Attribute.getOID(string);
        if (objectIdentifier == null) {
            throw new IOException("Attribute name " + string + " not recognized or not supported.");
        }
        return this.getAttributeValue(objectIdentifier);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("PKCS9 Attributes: [\n\t");
        boolean bl = true;
        for (int i = 1; i < PKCS9Attribute.PKCS9_OIDS.length; ++i) {
            PKCS9Attribute pKCS9Attribute = this.getAttribute(PKCS9Attribute.PKCS9_OIDS[i]);
            if (pKCS9Attribute == null) continue;
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(";\n\t");
            }
            stringBuffer.append(pKCS9Attribute.toString());
        }
        stringBuffer.append("\n\t] (end PKCS9 Attributes)");
        return stringBuffer.toString();
    }

    static DerEncoder[] castToDerEncoder(Object[] objectArray) {
        DerEncoder[] derEncoderArray = new DerEncoder[objectArray.length];
        for (int i = 0; i < derEncoderArray.length; ++i) {
            derEncoderArray[i] = (DerEncoder)objectArray[i];
        }
        return derEncoderArray;
    }
}

