/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.CertificateExtensions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Hashtable;
import sun.security.pkcs.SignerInfo;

public class PKCS9Attribute
implements DerEncoder {
    private static final String RSADSI_str = "1.2.840.113549";
    private static final String PKCS_str = "1.2.840.113549.1";
    private static final String PKCS9_str = "1.2.840.113549.1.9";
    static final ObjectIdentifier[] PKCS9_OIDS = new ObjectIdentifier[16];
    public static final ObjectIdentifier EMAIL_ADDRESS_OID;
    public static final ObjectIdentifier UNSTRUCTURED_NAME_OID;
    public static final ObjectIdentifier CONTENT_TYPE_OID;
    public static final ObjectIdentifier MESSAGE_DIGEST_OID;
    public static final ObjectIdentifier SIGNING_TIME_OID;
    public static final ObjectIdentifier COUNTERSIGNATURE_OID;
    public static final ObjectIdentifier CHALLENGE_PASSWORD_OID;
    public static final ObjectIdentifier UNSTRUCTURED_ADDRESS_OID;
    public static final ObjectIdentifier EXTENDED_CERTIFICATE_ATTRIBUTES_OID;
    public static final ObjectIdentifier ISSUER_SERIALNUMBER_OID;
    public static final ObjectIdentifier EXTENSION_REQUEST_OID;
    public static final ObjectIdentifier SMIME_CAPABILITY_OID;
    public static final String EMAIL_ADDRESS_STR = "EmailAddress";
    public static final String UNSTRUCTURED_NAME_STR = "UnstructuredName";
    public static final String CONTENT_TYPE_STR = "ContentType";
    public static final String MESSAGE_DIGEST_STR = "MessageDigest";
    public static final String SIGNING_TIME_STR = "SigningTime";
    public static final String COUNTERSIGNATURE_STR = "Countersignature";
    public static final String CHALLENGE_PASSWORD_STR = "ChallengePassword";
    public static final String UNSTRUCTURED_ADDRESS_STR = "UnstructuredAddress";
    public static final String EXTENDED_CERTIFICATE_ATTRIBUTES_STR = "ExtendedCertificateAttributes";
    public static final String ISSUER_SERIALNUMBER_STR = "IssuerAndSerialNumber";
    private static final String RSA_PROPRIETARY_STR = "RSAProprietary";
    private static final String SMIME_SIGNING_DESC_STR = "SMIMESigningDesc";
    public static final String EXTENSION_REQUEST_STR = "ExtensionRequest";
    public static final String SMIME_CAPABILITY_STR = "SMIMECapability";
    private static final Hashtable NAME_OID_TABLE;
    private static final Hashtable OID_NAME_TABLE;
    private static final Byte[][] PKCS9_VALUE_TAGS;
    private static final Class[] VALUE_CLASSES;
    private static final boolean[] SINGLE_VALUED;
    private int index;
    private Object value;

    public PKCS9Attribute(ObjectIdentifier objectIdentifier, Object object) throws IllegalArgumentException {
        this.init(objectIdentifier, object);
    }

    public PKCS9Attribute(String string, Object object) throws IllegalArgumentException {
        ObjectIdentifier objectIdentifier = PKCS9Attribute.getOID(string);
        if (objectIdentifier == null) {
            throw new IllegalArgumentException("Unrecognized attribute name " + string + " constructing PKCS9Attribute.");
        }
        this.init(objectIdentifier, object);
    }

    private void init(ObjectIdentifier objectIdentifier, Object object) throws IllegalArgumentException {
        this.index = PKCS9Attribute.indexOf(objectIdentifier, PKCS9_OIDS, 1);
        if (this.index == -1) {
            throw new IllegalArgumentException("Unsupported OID " + objectIdentifier + " constructing PKCS9Attribute.");
        }
        if (!VALUE_CLASSES[this.index].isInstance(object)) {
            throw new IllegalArgumentException("Wrong value class  for attribute " + objectIdentifier + " constructing PKCS9Attribute; was " + object.getClass().toString() + ", should be " + VALUE_CLASSES[this.index].toString());
        }
        this.value = object;
    }

    public PKCS9Attribute(DerValue derValue) throws IOException {
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derInputStream.available() != 0) {
            throw new IOException("Excess data parsing PKCS9Attribute");
        }
        if (derValueArray.length != 2) {
            throw new IOException("PKCS9Attribute doesn't have two components");
        }
        ObjectIdentifier objectIdentifier = derValueArray[0].getOID();
        this.index = PKCS9Attribute.indexOf(objectIdentifier, PKCS9_OIDS, 1);
        if (this.index == -1) {
            throw new IOException("Invalid OID for PKCS9 attribute: " + objectIdentifier);
        }
        DerValue[] derValueArray2 = new DerInputStream(derValueArray[1].toByteArray()).getSet(1);
        if (SINGLE_VALUED[this.index] && derValueArray2.length > 1) {
            this.throwSingleValuedException();
        }
        for (int i = 0; i < derValueArray2.length; ++i) {
            Byte by = new Byte(derValueArray2[i].getTag());
            if (PKCS9Attribute.indexOf(by, PKCS9_VALUE_TAGS[this.index], 0) != -1) continue;
            this.throwTagException(by);
        }
        switch (this.index) {
            case 1: 
            case 2: 
            case 8: {
                String[] stringArray = new String[derValueArray2.length];
                for (int i = 0; i < derValueArray2.length; ++i) {
                    stringArray[i] = derValueArray2[i].getAsString();
                }
                this.value = stringArray;
                break;
            }
            case 3: {
                this.value = derValueArray2[0].getOID();
                break;
            }
            case 4: {
                this.value = derValueArray2[0].getOctetString();
                break;
            }
            case 5: {
                this.value = new DerInputStream(derValueArray2[0].toByteArray()).getUTCTime();
                break;
            }
            case 6: {
                SignerInfo[] signerInfoArray = new SignerInfo[derValueArray2.length];
                for (int i = 0; i < derValueArray2.length; ++i) {
                    signerInfoArray[i] = new SignerInfo(derValueArray2[i].toDerInputStream());
                }
                this.value = signerInfoArray;
                break;
            }
            case 7: {
                this.value = derValueArray2[0].getAsString();
                break;
            }
            case 9: {
                throw new IOException("PKCS9 extended-certificate attribute not supported.");
            }
            case 10: {
                throw new IOException("PKCS9 IssuerAndSerialNumberattribute not supported.");
            }
            case 11: 
            case 12: {
                throw new IOException("PKCS9 RSA DSI attributes11 and 12, not supported.");
            }
            case 13: {
                throw new IOException("PKCS9 attribute #13 not supported.");
            }
            case 14: {
                this.value = new CertificateExtensions(new DerInputStream(derValueArray2[0].toByteArray()));
                break;
            }
            case 15: {
                throw new IOException("PKCS9 SMIMECapability attribute not supported.");
            }
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream;
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOID(this.getOID());
        switch (this.index) {
            case 1: 
            case 2: {
                derOutputStream = (DerOutputStream)this.value;
                DerOutputStream[] derOutputStreamArray = new DerOutputStream[((DerOutputStream)derOutputStream).length];
                for (int i = 0; i < ((DerOutputStream)derOutputStream).length; ++i) {
                    derOutputStreamArray[i] = new DerOutputStream();
                    derOutputStreamArray[i].putIA5String((String)derOutputStream[i]);
                }
                derOutputStream2.putOrderedSetOf((byte)49, (DerEncoder[])derOutputStreamArray);
                break;
            }
            case 3: {
                derOutputStream = new DerOutputStream();
                derOutputStream.putOID((ObjectIdentifier)this.value);
                derOutputStream2.write((byte)49, derOutputStream.toByteArray());
                break;
            }
            case 4: {
                derOutputStream = new DerOutputStream();
                derOutputStream.putOctetString((byte[])this.value);
                derOutputStream2.write((byte)49, derOutputStream.toByteArray());
                break;
            }
            case 5: {
                derOutputStream = new DerOutputStream();
                derOutputStream.putUTCTime((Date)this.value);
                derOutputStream2.write((byte)49, derOutputStream.toByteArray());
                break;
            }
            case 6: {
                derOutputStream2.putOrderedSetOf((byte)49, (DerEncoder[])this.value);
                break;
            }
            case 7: {
                derOutputStream = new DerOutputStream();
                derOutputStream.putPrintableString((String)this.value);
                derOutputStream2.write((byte)49, derOutputStream.toByteArray());
                break;
            }
            case 8: {
                derOutputStream = (DerOutputStream)this.value;
                DerOutputStream[] derOutputStreamArray = new DerOutputStream[((DerOutputStream)derOutputStream).length];
                for (int i = 0; i < ((DerOutputStream)derOutputStream).length; ++i) {
                    derOutputStreamArray[i] = new DerOutputStream();
                    derOutputStreamArray[i].putPrintableString((String)derOutputStream[i]);
                }
                derOutputStream2.putOrderedSetOf((byte)49, (DerEncoder[])derOutputStreamArray);
                break;
            }
            case 9: {
                throw new IOException("PKCS9 extended-certificate attribute not supported.");
            }
            case 10: {
                throw new IOException("PKCS9 IssuerAndSerialNumberattribute not supported.");
            }
            case 11: 
            case 12: {
                throw new IOException("PKCS9 RSA DSI attributes11 and 12, not supported.");
            }
            case 13: {
                throw new IOException("PKCS9 attribute #13 not supported.");
            }
            case 14: {
                derOutputStream = new DerOutputStream();
                CertificateExtensions certificateExtensions = (CertificateExtensions)this.value;
                try {
                    certificateExtensions.encode((OutputStream)derOutputStream, true);
                }
                catch (CertificateException certificateException) {
                    throw new IOException(certificateException.toString());
                }
                derOutputStream2.write((byte)49, derOutputStream.toByteArray());
                break;
            }
            case 15: {
                throw new IOException("PKCS9 attribute #15 not supported.");
            }
        }
        derOutputStream = new DerOutputStream();
        derOutputStream.write((byte)48, derOutputStream2.toByteArray());
        outputStream.write(derOutputStream.toByteArray());
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isSingleValued() {
        return SINGLE_VALUED[this.index];
    }

    public ObjectIdentifier getOID() {
        return PKCS9_OIDS[this.index];
    }

    public String getName() {
        return (String)OID_NAME_TABLE.get(PKCS9_OIDS[this.index]);
    }

    public static ObjectIdentifier getOID(String string) {
        return (ObjectIdentifier)NAME_OID_TABLE.get(string.toLowerCase());
    }

    public static String getName(ObjectIdentifier objectIdentifier) {
        return (String)OID_NAME_TABLE.get(objectIdentifier);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[");
        stringBuffer.append(OID_NAME_TABLE.get(PKCS9_OIDS[this.index]));
        stringBuffer.append(": ");
        if (SINGLE_VALUED[this.index]) {
            if (this.value instanceof byte[]) {
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                stringBuffer.append(hexDumpEncoder.encodeBuffer((byte[])this.value));
            } else {
                stringBuffer.append(this.value.toString());
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        boolean bl = true;
        Object[] objectArray = (Object[])this.value;
        for (int i = 0; i < objectArray.length; ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(objectArray[i].toString());
        }
        return stringBuffer.toString();
    }

    static int indexOf(Object object, Object[] objectArray, int n) {
        for (int i = n; i < objectArray.length; ++i) {
            if (!object.equals(objectArray[i])) continue;
            return i;
        }
        return -1;
    }

    private void throwSingleValuedException() throws IOException {
        throw new IOException("Single-value attribute " + this.getOID() + " (" + this.getName() + ")" + " has multiple values.");
    }

    private void throwTagException(Byte by) throws IOException {
        Byte[] byteArray = PKCS9_VALUE_TAGS[this.index];
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("Value of attribute ");
        stringBuffer.append(this.getOID().toString());
        stringBuffer.append(" (");
        stringBuffer.append(this.getName());
        stringBuffer.append(") has wrong tag: ");
        stringBuffer.append(by.toString());
        stringBuffer.append(".  Expected tags: ");
        stringBuffer.append(byteArray[0].toString());
        for (int i = 1; i < byteArray.length; ++i) {
            stringBuffer.append(", ");
            stringBuffer.append(byteArray[i].toString());
        }
        stringBuffer.append(".");
        throw new IOException(stringBuffer.toString());
    }

    static {
        try {
            for (int i = 1; i < PKCS9_OIDS.length; ++i) {
                PKCS9Attribute.PKCS9_OIDS[i] = new ObjectIdentifier("1.2.840.113549.1.9." + i);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EMAIL_ADDRESS_OID = PKCS9_OIDS[1];
        UNSTRUCTURED_NAME_OID = PKCS9_OIDS[2];
        CONTENT_TYPE_OID = PKCS9_OIDS[3];
        MESSAGE_DIGEST_OID = PKCS9_OIDS[4];
        SIGNING_TIME_OID = PKCS9_OIDS[5];
        COUNTERSIGNATURE_OID = PKCS9_OIDS[6];
        CHALLENGE_PASSWORD_OID = PKCS9_OIDS[7];
        UNSTRUCTURED_ADDRESS_OID = PKCS9_OIDS[8];
        EXTENDED_CERTIFICATE_ATTRIBUTES_OID = PKCS9_OIDS[9];
        ISSUER_SERIALNUMBER_OID = PKCS9_OIDS[10];
        EXTENSION_REQUEST_OID = PKCS9_OIDS[14];
        SMIME_CAPABILITY_OID = PKCS9_OIDS[15];
        NAME_OID_TABLE = new Hashtable(16);
        NAME_OID_TABLE.put("emailaddress", PKCS9_OIDS[1]);
        NAME_OID_TABLE.put("unstructuredname", PKCS9_OIDS[2]);
        NAME_OID_TABLE.put("contenttype", PKCS9_OIDS[3]);
        NAME_OID_TABLE.put("messagedigest", PKCS9_OIDS[4]);
        NAME_OID_TABLE.put("signingtime", PKCS9_OIDS[5]);
        NAME_OID_TABLE.put("countersignature", PKCS9_OIDS[6]);
        NAME_OID_TABLE.put("challengepassword", PKCS9_OIDS[7]);
        NAME_OID_TABLE.put("unstructuredaddress", PKCS9_OIDS[8]);
        NAME_OID_TABLE.put("extendedcertificateattributes", PKCS9_OIDS[9]);
        NAME_OID_TABLE.put("issuerandserialnumber", PKCS9_OIDS[10]);
        NAME_OID_TABLE.put("rsaproprietary", PKCS9_OIDS[11]);
        NAME_OID_TABLE.put("rsaproprietary", PKCS9_OIDS[12]);
        NAME_OID_TABLE.put("signingdescription", PKCS9_OIDS[13]);
        NAME_OID_TABLE.put("extensionrequest", PKCS9_OIDS[14]);
        NAME_OID_TABLE.put("smimecapability", PKCS9_OIDS[15]);
        OID_NAME_TABLE = new Hashtable(16);
        OID_NAME_TABLE.put(PKCS9_OIDS[1], EMAIL_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[2], UNSTRUCTURED_NAME_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[3], CONTENT_TYPE_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[4], MESSAGE_DIGEST_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[5], SIGNING_TIME_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[6], COUNTERSIGNATURE_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[7], CHALLENGE_PASSWORD_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[8], UNSTRUCTURED_ADDRESS_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[9], EXTENDED_CERTIFICATE_ATTRIBUTES_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[10], ISSUER_SERIALNUMBER_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[11], RSA_PROPRIETARY_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[12], RSA_PROPRIETARY_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[13], SMIME_SIGNING_DESC_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[14], EXTENSION_REQUEST_STR);
        OID_NAME_TABLE.put(PKCS9_OIDS[15], SMIME_CAPABILITY_STR);
        PKCS9_VALUE_TAGS = new Byte[][]{null, {new Byte(22)}, {new Byte(22)}, {new Byte(6)}, {new Byte(4)}, {new Byte(23)}, {new Byte(48)}, {new Byte(19), new Byte(20)}, {new Byte(19), new Byte(20)}, {new Byte(49)}, {new Byte(48)}, null, null, null, {new Byte(48)}, {new Byte(48)}};
        VALUE_CLASSES = new Class[16];
        try {
            Class<?> clazz = Class.forName("[Ljava.lang.String;");
            PKCS9Attribute.VALUE_CLASSES[0] = null;
            PKCS9Attribute.VALUE_CLASSES[1] = clazz;
            PKCS9Attribute.VALUE_CLASSES[2] = clazz;
            PKCS9Attribute.VALUE_CLASSES[3] = Class.forName("com.ibm.security.util.ObjectIdentifier");
            PKCS9Attribute.VALUE_CLASSES[4] = Class.forName("[B");
            PKCS9Attribute.VALUE_CLASSES[5] = Class.forName("java.util.Date");
            PKCS9Attribute.VALUE_CLASSES[6] = Class.forName("[Lsun.security.pkcs.SignerInfo;");
            PKCS9Attribute.VALUE_CLASSES[7] = Class.forName("java.lang.String");
            PKCS9Attribute.VALUE_CLASSES[8] = clazz;
            PKCS9Attribute.VALUE_CLASSES[9] = null;
            PKCS9Attribute.VALUE_CLASSES[10] = null;
            PKCS9Attribute.VALUE_CLASSES[11] = null;
            PKCS9Attribute.VALUE_CLASSES[12] = null;
            PKCS9Attribute.VALUE_CLASSES[13] = null;
            PKCS9Attribute.VALUE_CLASSES[14] = Class.forName("com.ibm.security.x509.CertificateExtensions");
            PKCS9Attribute.VALUE_CLASSES[15] = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ExceptionInInitializerError(classNotFoundException.toString());
        }
        SINGLE_VALUED = new boolean[]{false, false, false, true, true, true, false, true, false, false, true, false, false, false, true, true};
    }
}

