/*
 * Copyright 2001-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*
 * $Id: TemplatesImpl.java,v 1.34 2004/02/23 10:29:36 aruny Exp $
 */

package org.apache.xalan.xsltc.trax;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Properties;
import java.security.AccessController;
import java.security.PrivilegedAction;

import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;

import org.apache.xalan.xsltc.DOM;
import org.apache.xalan.xsltc.Translet;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.runtime.AbstractTranslet;
import org.apache.xalan.xsltc.runtime.Hashtable;

/**
 * A proxy class to implement Templates interface without implementing serializable
 */
public final class TemplatesImplProxy implements Templates {
    private TemplatesImpl templatesImpl = null;
    /**
     * Create a wrapper to an XSLTC template object from the bytecodes.
     * The bytecodes for the translet and auxiliary classes, plus the name of
     * the main translet class, must be supplied.
     */
    protected TemplatesImplProxy(byte[][] bytecodes, String transletName,
        Properties outputProperties, int indentNumber,
        TransformerFactoryImpl tfactory) 
    {
            templatesImpl = new TemplatesImpl(bytecodes, transletName, 
                outputProperties, indentNumber, tfactory);
    }
    
    /**
     * Create a wrapper to an XSLTC template object from the translet class definition(s).
     */
    protected TemplatesImplProxy(Class[] transletClasses, String transletName,
        Properties outputProperties, int indentNumber,
        TransformerFactoryImpl tfactory) 
    { 
             templatesImpl = new TemplatesImpl(transletClasses, transletName, 
                outputProperties, indentNumber, tfactory);
    }

     /**
     * Store URIResolver needed for Transformers.
     */
    public void setURIResolver(URIResolver resolver) {
        templatesImpl.setURIResolver(resolver);
    }

    /**
     * Returns the translet bytecodes stored in this template
     */
    public byte[][] getTransletBytecodes() {
        return templatesImpl.getTransletBytecodes();
    }

    /**
     * Returns the translet bytecodes stored in this template
     */
    public Class[] getTransletClasses() {
        return templatesImpl.getTransletClasses();
    }

    /**
     * Returns the index of the main class in array of bytecodes
     */
    public int getTransletIndex() {
        return templatesImpl.getTransletIndex();
    }

    /**
     * Implements JAXP's Templates.newTransformer()
     *
     * @throws TransformerConfigurationException
     */
    public Transformer newTransformer()
        throws TransformerConfigurationException 
    {
        return templatesImpl.newTransformer();
    }

    /**
     * Implements JAXP's Templates.getOutputProperties(). We need to 
     * instanciate a translet to get the output settings, so
     * we might as well just instanciate a Transformer and use its
     * implementation of this method.
     */
    public Properties getOutputProperties() { 
        return templatesImpl.getOutputProperties();
    }

    /**
     * Return the thread local copy of the stylesheet DOM.
     */
    public DOM getStylesheetDOM() {
        return templatesImpl.getStylesheetDOM();
    }
    
    /**
     * Set the thread local copy of the stylesheet DOM.
     */
    public void setStylesheetDOM(DOM sdom) {
        templatesImpl.setStylesheetDOM(sdom);
    }
}
