/*
 * @(#)src/tools/pfm/java_md.c, tool, ax142, 20050221 1.39.1.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */




/*
 * Function:
 *     Platform specific code for the java launcher for Unix platforms
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    --------------------------------------------------
 *  41302  040302 kwb       Globalize the java launcher
 *  42361  010402 ansriniv  failed to create VM
 *  42483  100402 sgollapa  Add jre/bin path to LD_LIBRARY_PATH .
 *  42183.1 130502 ansriniv JDK 1.3.1 is broken out-of-the-box on RH 7.1
 *  51090  200502 pratunga  42183.1 changes required only for IA32
 *  51253  210602 smithwil  Add dummy reference to __moddi3 for linking
 *  53141  110702 nmasson   Fix FindJVMDLL
 *  53433  230702 nrichard  Correct LDT_works calculation
 *  53864  010802 nrichard  Enhancement to disable_floating_stacks calculation
 *  55562  260902 kwb       Map zh_HK and zh_MO to use zh_TW
 *  54075  241002 bygravec  Move gdbjava functionality into executable
 *  57930.1 210203 ansriniv Set env. var for LKP automatically
 *  57204   150103 websterm Sidecar launcher
 *  63576.1 130803 nmasson  Add IBM_USE_FLOATING_STACKS override
 *  64690  260903 psman     Back out 51253
 *  65255  291003 belldav   enable IBM_JVM_DEBUG_PROG across Linux
 *  67702  140104 dineeno   Make Error loading DLL message more helpful
 *  67741  050204 mbluemel  Support -Xpd (launch PD build libraries)
 *  74242  090604 dineeno   Stop launcher stripping items from LD_LIBRARY_PATH
 *  71326  230604 pratunga  Produce correct -X usage text for J9
 *  79867  211204 pratunga Produce -X help text of j9 for sidecar builds
 */


#include "java.h"
#include <dlfcn.h>
#include <string.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <locale.h>
//ibm@7468  begin
#if defined(IBM_LINUX)
/*
 *  libgen.h removed from Linux as it redefines basename to be
 *  __xpg_basename which gives incorrect results.  The prototypes for
 *  dirname and basename are instead defined here
 */
extern char *basename(const char *filename);
extern char *dirname(const char *path);
#define TRUE 1						    /*ibm@7468*/
#define FALSE 0						    /*ibm@7468*/
#else
#include <libgen.h>
#endif
//ibm.@7468  end
#include <sys/stat.h>					    /*ibm@106*/
#include <errno.h>					    /*ibm@7468*/

#if defined(IBM_LINUX)
#if defined(i386)					    /*ibm@51090*/
#include <sys/utsname.h>					 /*ibm@42183.1*/
#include <sys/unistd.h>						/*ibm@53433*/
#endif
#define JNI_LIB_PREFIX		"lib"
#define JNI_LIB_SUFFIX		".so"
#define SYS_LIBRARY_PATH	"LD_LIBRARY_PATH"
#else
#define JNI_LIB_PREFIX		"lib"
#define JNI_LIB_SUFFIX		".a"
#define SYS_LIBRARY_PATH	"LIBPATH"
#endif

#if defined(IBM_BUILD_TYPE_dev)
    #define JVM_DLL  JNI_LIB_PREFIX "jvm" JNI_LIB_SUFFIX       /*ibm@67741*/
#elif defined(IBM_BUILD_TYPE_col)
    #define JVM_DLL  JNI_LIB_PREFIX "jvm_g" JNI_LIB_SUFFIX
#else
    #define JVM_DLL  JNI_LIB_PREFIX "jvm" JNI_LIB_SUFFIX
#endif

static char * JavaHomeDir;     /* Home directory - sdk		   */
static char * JavaJREDir;      /* JRE directory  - jre/sdk	   */
static char JavaLibDir[MAXPATHLEN];               /*ibm@67741*/
static char * JavaJVMDir;      /* JVM directory  - sdk/jre/classic */
static char JVMType[16];       /* JVM type  "", "classic"	   */

/* start ibm@1369
 * Expand command line arguments.
 */
void
ExpandCommandLineArgs() {
    /* DO NOTHING */
}
/* end   ibm@1369 */

/**************************************************************************
 * name		- ibmFindJVMDLL
 * description  -
 *      Find a JVM DLL.
 *
 * parameters   - jvmtype (the name of the jvm type : "classic" or "hotspot")
 * returns      - path to JVM DLL
 **************************************************************************/
static char *						     /*ibm@106*/
ibmFindJVMDLL(char * jvmtype) {
    struct stat s;
    char   home[MAXPATHLEN];
    char * p;

/*ibm@67741*/
#define JRE_BIN "/jre/bin/"
#define JRE_PD_BIN "/jre/pd/bin/"
#define BIN "/bin/"
#define PD_BIN "/pd/bin/"

    char *binDir;
    char *jreBinDir;
/*ibm@67741*/

    memset(JVMType, 0, 16);
    if (jvmtype) {                                      /*ibm@67741*/
        if (strcmp(jvmtype,"sovPd") != 0) {             /*ibm@67741*/
            strncpy(JVMType, jvmtype, 15);
            binDir = BIN;                               /*ibm@67741*/
            jreBinDir = JRE_BIN;                        /*ibm@67741*/
        } else {                                        /*ibm@67741*/
            strcpy(JVMType,"classic");                  /*ibm@67741*/
            binDir = PD_BIN;                            /*ibm@67741*/
            jreBinDir = JRE_PD_BIN;                     /*ibm@67741*/
        }
    } else {
        memset(JVMType, 0, 16);
        binDir = BIN;                                   /*ibm@67741*/
        jreBinDir = JRE_BIN;                            /*ibm@67741*/
    }                                                   /*ibm@67741*/

    GetApplicationHome(home, MAXPATHLEN-50);
    if (!*home)
	return NULL;
    p = home + strlen(home);       /* pointer to end of home */

    /* Try to load J9 JVM. */
    /*ibm@57204*/
    if (jvmtype != NULL) {
        strcpy(p, jreBinDir);      /*ibm@67741*/
        strcat(p, JVMType);
        strcat(p, "/" JVM_DLL);
        if (0 != stat(home, &s))
            jvmtype = NULL;
    }

    if (jvmtype==NULL) {
	/* Try <home>/jre(/pd)/bin */
	strcpy(p, jreBinDir);
	strcat(p, JVM_DLL);        /*ibm@67741*/
	if (stat(home, &s) == 0) {
	    return strdup(home);
	}

	/* try <home>(/pd)/bin */
	strcpy(p, binDir);        /*ibm@67741*/
	strcat(p, JVM_DLL);       /*ibm@67741*/
	if (stat(home, &s) == 0) {
	    return strdup(home);
	}
	strcpy(JVMType, "classic");
    }

    /* try <home>/jre(/pd)/bin/classic */
    strcpy(p, jreBinDir);         /*ibm@67741*/
    strcat(p, JVMType);
    strcat(p, "/" JVM_DLL);
    if (stat(home, &s) == 0) {
	return strdup(home);
    }

    /* try <home>(/pd)/bin/classic */
    strcpy(p, binDir);					/*ibm@53141,ibm@67741*/
    strcat(p, JVMType);
    strcat(p, "/" JVM_DLL);				/*ibm@53141*/
    if (stat(home, &s) == 0) {
	return strdup(home);
    }

    /* JVM not found */
    return(char *)NULL;
}


/**************************************************************************
 * name	       - LoadJavaVM (ibm@149)
 * description -
 *      Load JVM and initialize the invocation functions.  Dynamically
 *      open the jvm shared library and find the entry points.
 *
 * parameters  - jvmtype (name of jvm type, currently "classic")
 *		 ifn (vector of functions which receives the function
 *		      pointers found in the jvm DLL)
 * returns     - JNI_TRUE if successful
 **************************************************************************/
jboolean
LoadJavaVM(char *jvmtype, InvocationFunctions *ifn) {
    char * jvmpath, * jp;
    void * hJvm;

    if (!JavaJVMDir) {					/*ibm@53141*/
	showMessage(stderr, "JVM.not.found", c2jc(JVM_DLL), NULL, 0);
	return JNI_FALSE;
    }
    jvmpath = MemAlloc(strlen(JavaJVMDir) + 50);
    strcpy(jvmpath, JavaJVMDir);
    strcat(jvmpath, "/"JVM_DLL);
    hJvm = dlopen(jvmpath,RTLD_LAZY);
    if (hJvm==NULL) {
	if (debug) {
	    fprintf(stderr, "LoadJavaVM: unable to open DLL (%s)\n", jvmpath);
	    fprintf(stderr, "%s\n", dlerror());
	}
	if (errno == ENAMETOOLONG) {
	    showMessage(stderr, "Path.too.long", c2jc(SYS_LIBRARY_PATH), NULL, 0);
	} else {
	    showMessage(stderr, "Error.loading", c2jc(dlerror()), NULL, 0); /*ibm@67702*/    
	}
	free(jvmpath);
	return JNI_FALSE;
    }

    ifn->CreateJavaVM = (jint (JNICALL *)(JavaVM **pvm, void **penv, void *args))
			dlsym(hJvm,"JNI_CreateJavaVM");
    ifn->GetDefaultJavaVMInitArgs = (jint (JNICALL *)(void *args))
				    dlsym(hJvm,"JNI_GetDefaultJavaVMInitArgs");
/*ibm@71326 start*/
    if (strcmp(jvmtype,"j9vm") == 0) {                       /*ibm@79867*/
        ifn->GetXUsage = (jint (JNICALL *)(char *exename))
                         dlsym(hJvm,"GetXUsage");
    }
/*ibm@71326 end*/

    if (ifn->CreateJavaVM == 0 ||
	ifn->GetDefaultJavaVMInitArgs == 0) {
	showMessage(stderr, "JNI.interfaces.not.found", c2jc(jvmpath), NULL, 0);
	return JNI_FALSE;
    }
    free(jvmpath);
    return JNI_TRUE;
}

/**************************************************************************
 * name	       - GetXUsagePath
 * description -
 *      Get the path to the file that has the usage message for -X options.
 *
 * parameters  - buf (the receiving buffer for the path)
 *		 bufsize (the size of buf)
 * returns     -
 **************************************************************************/
void
GetXUsagePath(char *buf, jint bufsize) {
    *buf = 0;
}


/**************************************************************************
 * name	       - ResolveSymbol (ibm@7468)
 * description -
 *      Given a buffer containing a path resolve any symbols in the last
 *      component of the path. If the symbol resolves to a relative path
 *      add it to the original. Otherwise replace it.
 *
 * parameters  - pUsed (ptr to a buffer holding the current path)
 * returns     -
 *************************************************************************/
void
ResolveSymbol(char *pUsed) {
    char buffer[MAXPATHLEN];
    char *p = pUsed;
    int len;

    if ((len = readlink(pUsed, buffer, MAXPATHLEN)) >= 0) {
	buffer[len] = 0;

	/* Did it resolve to a relative symbol ? */
	if (buffer[0] != '/') {				    /*ibm@8327*/
	    p= strrchr(pUsed, '/')+1;
	}

	strcpy(p, buffer);
    } else if (len == MAXPATHLEN) {
	fprintf(stderr, "BuildPath: Symbolic link too long > %d\n", MAXPATHLEN);
	fprintf(stderr, "BuildPath: using %s\n", pUsed);
    } else if (errno != EINVAL) {
	fprintf(stderr, "BuildPath: %s\n", strerror(errno));
	fprintf(stderr, "BuildPath: using %s\n", pUsed);
    }

}


/**************************************************************************
 * name	       - DeDot (ibm@7468)
 * description -
 *      Given a path in pUsed remove any trailing "."s, resolve any
 *      trailing ".."s resolving symbolic links before removal.
 *
 * parameters  - pUsed (ptr to a buffer holding the path)
 * returns     -
 *************************************************************************/
void
DeDot(char *pUsed) {
    char *p;

    /*
     * Remove any trailing "."s
     * stopping when we get to a non-dot item or
     * we have consumed the whole path
     */
    while (strcmp(basename(pUsed),".") == 0 && strcmp(pUsed,".") != 0) {
	p = dirname(pUsed);
	if (pUsed != p) {
	    strcpy(pUsed, p);
	}
    }

    if (strcmp(basename(pUsed),"..") == 0) {
	p = dirname(pUsed);
	if (pUsed != p) {
	    strcpy(pUsed, p);
	}

	DeDot(pUsed);
	ResolveSymbol(pUsed);
	p = dirname(pUsed);
	if (pUsed != p) {
	    strcpy(pUsed, p);
	}
    }

    /* ibm@4885 If all that we have left is a single "."
     * replace it with the current working directory
     */
    if (strcmp(pUsed, ".") == 0) {
	getcwd(pUsed, MAXPATHLEN);
    }

}

/**************************************************************************
 * name	       - BuildHomeDir (ibm@7468)
 * description -
 *      From the supplied executable name determine the true home directory.
 *      This function is called once to set up JavaHomeDir.
 *
 * parameters  - fname (The name of this executable, may be short or long)
 * returns     -
 *************************************************************************/
void
BuildHomeDir(char *fname) {
    char *path;
    char *p;
    int len;
    char dir[MAXPATHLEN];
    char *found = NULL;
    struct stat s;
    mode_t mode;							/*ibm@39752.1*/

    /*
     *  Is the exe name fully, or partially qualified?
     */
    if (strchr(fname, '/') != NULL && stat(fname, &s) == 0) {
	if (fname[0] == '/') {
	    strcpy(dir, fname);
	    found = dir;
	} else {
	    getcwd(dir, MAXPATHLEN);

	    path = dir;
	    p = fname;
	    while (p[0] == '.') {
		if (strstr(p, "../") == p) {
		    p = p+3;
		    path = dirname(path);
		} else {
		    p = p+2;
		}
	    }
	    strcat(path, "/");
	    strcat(path, p);

	    found = path;
	}
    } else {
	/*
	 * If not found, assume it's a short name and search the path variable...
	 */

	path = getenv("PATH");

	while (path != NULL) {
	    /*
	     *  Get the first element of the path
	     */

	    p = strchr(path, ':');

	    if (p != NULL) {

		/*
		 * There is more than one
		 */
		len = p - path;
		strncpy(dir, path, len);
		dir[len] = 0;
		path = p+1;
	    } else {

		/*
		 * Last path element...
		 */
		strcpy(dir, path);
		path = NULL;
	    }

	    /*
	     * Add the exe name to the path element and check it points to a file.
	     */
	    len = strlen(dir);					   /*ibm@42361*/
	    if (dir[len - 1] != '/') {				   /*ibm@42361*/
		strcat(dir, "/");
	    }							   /*ibm@42361*/
	    strcat(dir, fname);
	    if (stat(dir, &s) == 0) {
		mode = s.st_mode & S_IFMT;				/*ibm@39752.1*/
		if (mode == S_IFREG) {					/*ibm@39752.1*/
		    /*
		     * We have found a match!
		     */
		    found = dir;
		    break;
		}							/*ibm@39752.1*/
	    }

	}

    }

    /*
     * Did we find it?
     */
    if (found != NULL) {
	/*
	 * Resolve symbolic link in name
	 */
	ResolveSymbol(found);

	/*
	 * Strip the exc's name off the end.
	 */
	p = dirname(found);
	if (found != p) {
	    strcpy(found, p);
	}

	ResolveSymbol(found);

	DeDot(found);

	if (strcmp(basename(found), "exe") == 0) {
	    p = dirname(found);
	    if (found != p) {
		strcpy(found, p);
	    }
	}
	JavaJREDir = strdup(found);
	if (debug) {						/*ibm@53141*/
	    fprintf(stderr, "JavaJREDir  = %s\n", JavaJREDir);
	}
	/*
	 * Remove the next component which should be /bin
	 */
	p = dirname(found);
	if (found != p) {
	    strcpy(found, p);
	}

	ResolveSymbol(found);

	DeDot(found);

	/*
	 * If the next component is /jre remove it
	 */
	if (strcmp(basename(found),"jre") == 0) {
	    p = dirname(found);
	    if (found != p) {
		strcpy(found, p);
	    }

	    ResolveSymbol(found);

	    DeDot(found);
	}
	JavaHomeDir = strdup(found);
	if (debug) {
	    fprintf(stderr, "JavaHomeDir = %s\n", JavaHomeDir);/*ibm@53141*/
	}
    }
}

/**************************************************************************
 * name	       - GetApplicationHome (ibm@7468)
 * description -
 *      Get the application home directory, which will have been calculated
 *      by BuildHomeDir.
 *
 * parameters  - buf     The receiving buffer for the path
 *		 bufsize The size of the receiving buffer (not used)
 * returns     - JNI_TRUE
 **************************************************************************/
jboolean
GetApplicationHome(char *buf, jint bufsize) {
    strncpy(buf, JavaHomeDir, bufsize-1); /*ibm@26075*/
    buf[bufsize-1] = 0;
    return JNI_TRUE;
}

/**************************************************************************
 * name	       - setLibPath (ibm@7468)
 * description -
 *      Clean up the LD_LIBRARY_PATH environment variable, and add our bin
 *      directory to it.
 *
 * parameters  -
 * returns     -
 **************************************************************************/
void
setLibPath(char *jvmtype) {

    char * newpath;
    char *p;
    char *path = getenv(SYS_LIBRARY_PATH);
    int len;
    int totlen;

    if (!path) path = "";
    totlen = strlen(path)+strlen(JavaHomeDir)*3+100; /*ibm@42483*/
    newpath = MemAlloc(totlen);

    /*
     * Add the jre(/pd)/bin directory to the start of LD_LIBRARY_PATH
     */
    strcpy(newpath, SYS_LIBRARY_PATH "=");
    strcat(newpath, JavaLibDir);                    /*ibm@67741*/
    if (strcmp(JavaLibDir, JavaJVMDir)) {           /*ibm@67741*/
	strcat(newpath, ":");
	strcat(newpath, JavaJVMDir);
	strcat(newpath, ":"); /*ibm@42483*/
	strcat(newpath, JavaHomeDir); /*ibm@42483*/
        if (strcmp(jvmtype,"sovPd") != 0) {        /*ibm@67741*/
	    strcat(newpath, "/jre/bin"); /*ibm@42483*/
        } else {
	    strcat(newpath, "/jre/pd/bin");        /*ibm@67741*/
        }
    }

    /*
     * Now clean up LD_LIBRARY_PATH
     */
    while (path != NULL) {

	/* Get the first element of the path */

	p = strchr(path, ':');

	if (p == path) {
	    /* Discard null path entry "::" */
	    p++;
	} else {
	    if (p != NULL) {
		len = p - path;
		p++;
	    } else {
		len = strlen(path);
	    }

            if (len > 0) {
	        /* Discard trailing path separator */
	        if (path[len-1] == '/') {
		    len--;
	        }
		strcat(newpath, ":");
		strncat(newpath, path, len);
	    }
	}

	/* Move to the next path item */
	path = p;

    }

    putenv(strdup(newpath));
    MemFree(newpath);
}

/**************************************************************************
 * name	       - setEnvVars (ibm@6796)
 * description -
 *      Set the environment variables needed by Java.
 *
 * parameters  -
 * returns     -
 **************************************************************************/
void
setEnvVars() {
#ifdef IBM_AIX
    putenv("MALLOCMULTIHEAP=1");				/*ibm@8392*/
    putenv("AIXTHREAD_SCOPE=S");				/*ibm@8392*/

    /* IBM@8872 We need these options below for all builds now */
    putenv("AIXTHREAD_MUTEX_DEBUG=OFF");			/*ibm@8392*/
    putenv("AIXTHREAD_RWLOCK_DEBUG=OFF");			/*ibm@8392*/
    putenv("AIXTHREAD_COND_DEBUG=OFF");				/*ibm@8392*/

#if defined(__64BIT__)
    putenv("NULLPTR=NOSEGV");					/*ibm@24449*/
#endif
#endif

}

/**************************************************************************
 * name	       - setLibAndExec (ibm@7468)
 * description -
 *      AIX and Linux dlopen have problems with LD_LIBRARY_PATH changes
 *      made in the same process that is calling dlopen. Both use the
 *      value of LD_LIBRARY_PATH at process exec time. If JAVA has been
 *      executed without LD_LIBRARY_PATH containing the java lib paths,
 *      this function adds them, and re-execs JAVA to ensure that dlopen
 *      sees the new LD_LIBRARY_PATH setting.
 *
 * parameters  - argc (The count of arguments passed to main)
 *		 arcv (Array of parameters taken from the command line)
 * returns     -
 **************************************************************************/
void
setLibAndExec(int argc, char *argv[], char * jvmtype) {
    char *p, *path;
    char *buffer;
    char * jvmpath, * jp;
    int lib1 = FALSE, lib2 = FALSE;
    int new_scope_needed = FALSE;
    int new_ulimit_needed = FALSE;
    int libfound;
#ifdef IBM_AIX
    struct rlimit64 limit;
#endif
/*ibm@42183.1, start*/
#if defined(IBM_LINUX) && defined(i386)				/*ibm@51090*/
    struct utsname uinfo;
    unsigned int k_major = 0;
    unsigned int k_minor = 0;
    unsigned int k_delta = 0;
    int is_MP = FALSE;						/*ibm@53433*/
    int disable_floating_stacks;				/*ibm@53433*/
    char sysname[10];                                            /*ibm@57930.1*/
    FILE *sys_file = NULL;                                       /*ibm@57930.1*/
#endif
/*ibm@65255 start*/
    const int MAX_ARGS=(20);
    char *debugProg = NULL;                                     /*ibm@54075*/
    char **debugJavaArgs = (char**) malloc(sizeof(char *)*(MAX_ARGS+argc));
    char *delim = NULL;
    char *token = NULL;
    int argCount = 0;
    int count = 0;
/*ibm@65255 end*/

/*ibm@42183.1, end*/
    /*
     * Duplicate this here to make sure that we get the debug output
     * before the LIBPATH is set up.
     */
    if (getenv("_JAVA_LAUNCHER_DEBUG") != 0) {
	debug = JNI_TRUE;
    }

    /*
     * Find the application home dir from the application name
     */
    BuildHomeDir(argv[0]);

    //ibm.41302  begin
    /*
     * Find the JVM
     */
    jvmpath = ibmFindJVMDLL(jvmtype);
    if (!jvmpath)
	return;
    JavaJVMDir = strdup(jvmpath);
    jp = strrchr(JavaJVMDir, '/');
    if (jp) *jp=0;
    if (debug)
	fprintf(stderr, "JavaJVMDir  = %s\n", JavaJVMDir);
    //ibm.41302  end

    /*
     * Look through LIBPATH for the java libraries.  Ensure
     * the current java libraries are before other potentially
     * conflicting libraries.
     */
   /*ibm@67741 - hack "pd" into paths if necessary*/
    strcpy(JavaLibDir,JavaJREDir);
    if (strcmp(jvmtype,"sovPd") == 0) {
        p=strrchr(JavaLibDir,'/');
        strcpy(p,"/pd/bin");
    }

    p = getenv(SYS_LIBRARY_PATH);
    if (!p) p = "";
    buffer = strdup(p);
    path = buffer;
    while (path != NULL) {
	if ((p = strchr(path, ':')) != NULL) {
	    *p++ = 0;
	}
	if (!strcmp(path, JavaJVMDir)) {
	    lib1 = TRUE;
	    if (!strcmp(path, JavaLibDir))      /*ibm@67741*/
		lib2 = TRUE;
	} else if (!strcmp(path, JavaLibDir)) { /*ibm@67741*/
	    lib2 = TRUE;
	} else {
	    break;
	}
	path = p;
    }
    free (buffer);

    if (!lib1 || !lib2) {
	setLibPath(jvmtype);                    /*ibm@67741*/
    }

#ifdef IBM_AIX
    /*
     * If the user has not set the thread scope, or has not set it to 'S',
     * we must reset it. This will enable a user with the correct environment
     * to avoid an execvp, the same is true for the otehr flags below.
     */
    p = getenv("AIXTHREAD_SCOPE");				/*ibm@9197*/
    if (!(p && !strcmp(p, "S"))) {				/*ibm@9197*/
	new_scope_needed=TRUE;					/*ibm@9197*/
    }

    p = getenv("AIXTHREAD_MUTEX_DEBUG");			/*ibm@8872*/
    if (!(p && !strcmp(p, "OFF"))) {				/*ibm@8872*/
	new_scope_needed=TRUE;					/*ibm@8872*/
    }

    p = getenv("AIXTHREAD_RWLOCK_DEBUG");			/*ibm@8872*/
    if (!(p && !strcmp(p, "OFF"))) {				/*ibm@8872*/
	new_scope_needed=TRUE;					/*ibm@8872*/
    }

    p = getenv("AIXTHREAD_COND_DEBUG");				/*ibm@8872*/
    if (!(p && !strcmp(p, "OFF"))) {				/*ibm@8872*/
	new_scope_needed=TRUE;					/*ibm@8872*/
    }
#endif


    /* This was moved in IBM@9197 but cannot be placed before tests above */
    /* or they will always see the correct settings		  IBM@8872*/
    setEnvVars();

#ifdef IBM_AIX
    /*
     * ibm@24999
     * This mechanism is implemented in AIX on both PowerPC and
     * IA64 and is related to the static linker binder option
     * -bmaxdata, but is more flexible because the user
     * may set their own environment variable value of number of
     * segments for private data that is used for malloc() memory
     * allocations including thread stacks and the default Java
     * heap.
     * ibm@29024
     * Using LDR_CNTRL=MAXDATA is needed in both 32-bit and 64-bit
     * to use its ability to override the user soft data limit.
     */

    #if !defined(__64BIT__) || defined(_ARCH_IA64)      /* ibm@32140*/

    /* If NOT PPC64 - Check for "LDR_CNTRL" */

    p = getenv("LDR_CNTRL");
    if (p == NULL) {
	/*
	 * The maximum value is 0x80000000 for 8x256Mb segments.
	 *
	 * The user has not already specified another value, so
	 * use the 0x80000000 value to give the same behaviour
	 * as our legacy AIX PowerPC 32-bit 1.3 JVM which was
	 * statically linked with -bmaxdata for all of the launcher
	 * executables.
	 * NB. This applies to 32-bit on both IA64 and PowerPC;
	 * at some future time, we should look at removing use of
	 * the -bmaxdata binder option on PowerPC.
	 */
	putenv("LDR_CNTRL=MAXDATA=0x80000000");
	new_scope_needed = TRUE;
    }

    #endif       /* ibm@32140*/

    #if defined(__64BIT__)   /*ibm@33012*/
	getrlimit64(RLIMIT_DATA,&limit);			    /*ibm@32147*/
    if ((limit.rlim_cur) != RLIM64_INFINITY) {			/*ibm@32147*/
	limit.rlim_cur = RLIM64_INFINITY;			/*ibm@32147*/
	setrlimit64(RLIMIT_DATA,&limit);			/*ibm@32147*/
	new_ulimit_needed=TRUE;					/*ibm@32147*/
    }								/*ibm@32147*/
    #endif		     /*ibm@33012*/
#endif    /* IBM_AIX */

/*ibm@42183.1
 * IBM.FIXME
 * This fix is a workaround to disable the floating stacks on the Linux machines
 * with kernel < 2.4 (on UP), < 2.4.10 (on SMP) or with glibc which doesn't have
 * pthread_getattr_np.
 * At this point of time the supported distros include RH Advanced Server 7.2
 * which is shipped with 2.4.9 kernel. So we need the fix here.
 * Once the supported distros ships with the above requirements,
 * we do not require the fix here.
 *
 */

/*ibm@42183.1, start*/
#if defined(IBM_LINUX) && defined(i386)				/*ibm@51090*/
    /*ibm@57930.1, start*/
    if ((sys_file = fopen("/proc/version", "r")) != NULL) {
        if ((fscanf(sys_file, "%9s ", sysname) == 1) && !strcmp(sysname, "LKP")) {
            putenv(strdup("IBM_NOLDT=1"));
        }
        fclose(sys_file);
    }
    /*ibm@57930.1, end*/
    uname(&uinfo);
    sscanf(uinfo.release, "%u.%u.%u", &k_major, &k_minor, &k_delta);
    is_MP = (sysconf(_SC_NPROCESSORS_CONF) > 1);		/*ibm@53433*/

    /*ibm@53864 start*/
    disable_floating_stacks = TRUE;
    if ((k_major > 2) ||
	((k_major == 2) &&
	 ((k_minor > 4) ||
	  ((k_minor == 4) &&
	   (k_delta >= 10))))) {
	disable_floating_stacks = FALSE;
    } else if (!is_MP &&
	       ((k_major > 2) ||
		((k_major == 2) &&
		 (k_minor >= 4)))) {
	/*
	 * Floating stacks can only be supported if the system call
	 * pthread_getattr_np() is available (otherwise we run the risk
	 * of hitting a kernel bug when finding out thread stack info.
	 *
	 * NB: This should match the logic whic hworks this out in the HPI.
	 */
	const char* fn_name = "pthread_getattr_np";
	void* known_symbol;
	void* pthread_getattr_np;

	/*
	 * First, discover whether we've already got libpthread loaded,
	 * by searching for a symbol which will always be in our global
	 * scope if it is - pthread_create, for example.
	 */
	known_symbol = dlsym(RTLD_DEFAULT, "pthread_create");

	if (known_symbol != NULL) {
	    /*
	     * libpthread is already loaded, so if pthread_getattr_np
	     * exists, it will be found in our global scope.
	     */
	    pthread_getattr_np = dlsym(RTLD_DEFAULT, fn_name);
	} else {
	    void* pthread_lib;

	    /*
	     * libpthread isn't loaded yet, so do so using
	     * sysLoadLibrary(), then try to find pthread_getattr_np
	     * within it.
	     */
	    pthread_lib = dlopen("libpthread.so", RTLD_LAZY | RTLD_GLOBAL);
	    if (pthread_lib != NULL) {
		pthread_getattr_np = dlsym(pthread_lib, fn_name);
		dlclose(pthread_lib);
	    }
	}

	if (pthread_getattr_np != NULL) {
	    disable_floating_stacks = FALSE;
	}
    }
    /*ibm@53864 end*/

    /*ibm@63576.1 Override the above determination if the environment variable 
     * IBM_USE_FLOATING_STACKS is set
     */
    if (disable_floating_stacks) {
	if(getenv("IBM_USE_FLOATING_STACKS") == NULL) {		/*ibm@63576.1*/
	    putenv(strdup("LD_ASSUME_KERNEL=2.2.5"));
	}
    }
#endif
/*ibm@42183.1, end*/

    /*ibm@65255 start*/
    /*ibm@54075 start*/
    debugProg = getenv("IBM_JVM_DEBUG_PROG");
    if (debugProg && strcmp(debugProg, "")) {
        putenv(strdup("IBM_JVM_DEBUG_PROG="));
        printf("Found IBM_JVM_DEBUG_PROG=%s\n", debugProg);
        delim = " ";
        token = strtok(debugProg, delim);
        debugJavaArgs[argCount] = token;
        argCount++;
        token = strtok(NULL, delim);

        while(token != NULL) {
                if (argCount >= MAX_ARGS-3) {
                    printf("USAGE ERROR: too many arguments in IBM_JVM_DEBUG_PROG\n");
                    exit(-1);
                }
            debugJavaArgs[argCount] = token;
            token = strtok(NULL, delim);
            argCount++;
        }
        debugJavaArgs[argCount] = argv[0];

        count=1;
        if(!(strcmp(debugJavaArgs[argCount-1], "--args"))){
            for(;count<argc;count++) {
                debugJavaArgs[count+argCount] = argv[count];
            }
        }
        debugJavaArgs[count+argCount] = NULL;
        execvp(debugProg, debugJavaArgs);

        fprintf(stderr, "Execution of %s failed, ignoring IBM_JVM_DEBUG_PROG\n",
 debugProg);
        fflush(stderr);
    }
    /*ibm@54075 end*/
    /*ibm@65255 end*/

    if (!lib1 || !lib2 || new_scope_needed || new_ulimit_needed) {      /*ibm@9197,ibm@32147*/
	execvp(argv[0], argv);					/*ibm@9197*/
    }								/*ibm@9197*/
}


/*
 * Parse a platform name to separate the path and the file
 */
char * PlatformName(char * in, char * * cpath) {
    *cpath = ".";
    if (in[0]=='/') {
	char nbuf[PATH_MAX+1], * nptr;
	if (realpath(in, nbuf)) {
	    char * out = strdup(nbuf);
	    nptr = strrchr(out, '/');
	    if (out < nptr) {
		*cpath = out;
		*nptr = 0;
		return nptr+1;
	    }
	}
    }
    return in;
}


/*
 * Show a Unicode string.  This assumes that the wide char encoding
 * is in Unicode.  This is true for most current Unix systems.
 */
void ShowUnicode(FILE * f, jchar * str, int len) {
    char  * sbuf = MemAlloc(len*4 + 1);
    char  * sp;
    int     i, rc;

    for (i=0, sp=sbuf; i<len; i++) {
	rc = wctomb(sp, (wchar_t)str[i]);
	if (rc>0)
	    sp += rc;
    }
    *sp = 0;
    fwrite(sbuf, 1, (sp-sbuf), f);
    fflush(f);
    free(sbuf);
}


/*
 * Get the message file for this locale
 */
char * GetMessageFile(char *buf, jint bufsize) {
    char * cp;
    char   langname[8];
    char   ctryname[8];
    char * lc;

    /* Get the lang and country strings */
    lc = setlocale(LC_CTYPE, "");
    if (!lc) lc = "en";
    strncpy(langname, lc, 7);
    langname[7] = 0;
    ctryname[0] = 0;
    cp = strchr(langname, '_');
    if (cp) {
	*cp = 0;
	strcpy(ctryname, cp+1);
	ctryname[2] = 0;
    }

    /* Get the directory one up from that containing the jvm.dll */
    if ((strlen(JavaJREDir)+24) > bufsize) {
	return NULL;
    }

    strcpy(buf, JavaJREDir);
    cp = buf+strlen(buf);
    strcpy(cp, "/java_");
    cp += 6;

    /* Try for java_ll_CC.properties */
    if (*ctryname) {
	strcpy(cp, langname);
	strcat(cp, "_");
	strcat(cp, ctryname);
	strcat(cp, ".properties");
	if (!access(buf, 4))
            return buf;
    }

    //ibm.55562  begin
    /* Special case to map traditional chinese */
    if (!strcmp(langname, "zh") &&
        (!strcmp(ctryname, "HK") || !strcmp(ctryname, "MO"))) {
        strcpy(cp, "zh_TW.properties");
        if (!access(buf, 4))
            return buf;
    }
    //ibm.55562  end

    /* Try for java_ll.properties */
    if (*langname) {
        strcpy(cp, langname);
        strcat(cp, ".properties");
        if (!access(buf, 4))
            return buf;
    }

    /* Try for java.properties */
    strcpy(cp-1, ".properties");
    if (!access(buf, 4))
        return buf;

    return 0;
}

