/*
 * @(#)src/tools/sov/java.h, tool, as142, 20050517 1.13.1.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2002. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * ===========================================================================
 */

/*
 *
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 073964  010604 seb     Make jvmset a standard part of the build
 * 079867  211204 pratunga Produce -Xusage text of j9 for sidecar builds
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */






#ifndef _JAVA_H_
#define _JAVA_H_

/*
 * Get system specific defines.
 */
#include "jni.h"
#include "java_md.h"

/*
 * function types used for InvocationFunctions data type below.
 * ibm.91
 */
typedef jint (JNICALL *inv_func_create_t)(JavaVM **pvm, void **env, void *args);
typedef jint (JNICALL *inv_func_getargs_t)(void *args);
typedef jint (JNICALL *inv_func_getXUsage_t)(char *exename);   /*ibm@71326*/

/*
 * Pointers to the needed JNI invocation API, initialized by LoadJavaVM.
 */
typedef struct {
    inv_func_create_t CreateJavaVM;                     /* ibm.91 */
    inv_func_getargs_t GetDefaultJavaVMInitArgs;        /* ibm.91 */
    /*ibm@79867 - This function pointer is specific to J9 to get the Xusage text */
    inv_func_getXUsage_t GetXUsage;                     /*ibm@71326*/
} InvocationFunctions;

/*ibm@9648*/
#ifndef SetInternalLinkage
#define SetInternalLinkage()
#endif

/*
 * Message functions from java.c
 */
//ibm.41302   begin
int AddOption(char *str, void *info);                   /*ibm@73964*/
void *   MemAlloc(size_t size);
void     MemFree(void * mem);
jchar *  c2jc(char * str);
jchar *  js2jc(JNIEnv * env, jstring jstr);
jchar *  subMessage(jchar * msg, jchar * rep1, jchar * rep2, jint * lenp);
jchar *  getMessage(char * name);
jboolean showMessage(FILE * f, char * name, jchar * rep1,
                            jchar * rep2, int reterr);
//ibm.41302   end

/*
 * Protoypes for launcher functions in the system specific java_md.c.
 */
jboolean LoadJavaVM(char *jvmtype, InvocationFunctions *ifn);
void GetXUsagePath(char *buf, jint bufsize);
jboolean GetApplicationHome(char *buf, jint bufsize);
void ExpandCommandLineArgs(void);                                   /*ibm@1369*/

//ibm.41302   begin
char * PlatformName(char * in, char * * cpath);
char * GetMessageFile(char *buf, int bufsize);
void ShowUnicode(FILE * f, jchar * str, int len);
//ibm.41302   end


/*
 * Make launcher spit debug output.
 */
extern jboolean debug;

/*ibm@73964 start*/
#ifdef JVMSET
extern jboolean pdBuild;
extern char *pdPath;
#endif
/*ibm@73964 end*/

#endif /* _JAVA_H_ */
