/*
 * @(#)src/classes/sov/javax/transaction/xa/Xid.java, jdbc, as142, 20050517 1.5.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2002. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */




package javax.transaction.xa;

/**
 * The Xid interface is a Java mapping of the X/Open transaction identifier
 * XID structure. This interface specifies three accessor methods to 
 * retrieve a global transactions format ID, global transaction ID, 
 * and branch qualifier. The Xid interface is used by the transaction 
 * manager and the resource managers. This interface is not visible to
 * the application programs.
 */
public interface Xid {
    
    /**
     * Maximum number of bytes returned by getGtrid.
     */
    final static int MAXGTRIDSIZE = 64;

    /**
     * Maximum number of bytes returned by getBqual.
     */
    final static int MAXBQUALSIZE = 64;

    /**
     * Obtain the format identifier part of the XID.
     *
     * @return Format identifier. O means the OSI CCR format.
     */
    int getFormatId();

    /**
     * Obtain the global transaction identifier part of XID as an array 
     * of bytes.
     *
     * @return Global transaction identifier.
     */
    byte[] getGlobalTransactionId();

    /**
     * Obtain the transaction branch identifier part of XID as an array 
     * of bytes.
     *
     * @return Global transaction identifier.
     */
    byte[] getBranchQualifier();
}
