/*
 * @(#)src/classes/sov/javax/swing/text/html/TextAreaDocument.java, swing, as142, 20050517 1.13.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2003, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */
/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 63757  050903 slattery  Add IBM module header; 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)TextAreaDocument.java	1.7 03/01/23
 *
 */
package javax.swing.text.html;

import javax.swing.text.*;


/**
 * TextAreaDocument extends the capabilities of the PlainDocument 
 * to store the data that is initially set in the Document.
 * This is stored in order to enable an accurate reset of the 
 * state when a reset is requested.
 *
 * @author Sunita Mani
 * @version 1.7 01/23/03
 */
  
class TextAreaDocument extends PlainDocument {

    String initialText;
  

    /**
     * Resets the model by removing all the data,
     * and restoring it to its initial state.
     */
    void reset() {
	try {
	    remove(0, getLength());
	    if (initialText != null) {
		insertString(0, initialText, null);
	    }
	} catch (BadLocationException e) {
	}
    }

    /**
     * Stores the data that the model is initially
     * loaded with.
     */
    void storeInitialText() {
	try {
	    initialText = getText(0, getLength());
	} catch (BadLocationException e) {
	}
    }
}




