/*
 * @(#)src/classes/sov/javax/swing/text/html/IsindexView.java, swing, as142, 20050517 1.13.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2003, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */
/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 63757  050903 slattery  Add IBM module header; 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)IsindexView.java	1.10 03/01/23
 *
 */
package javax.swing.text.html;

import java.awt.*;
import java.awt.event.*;
import java.net.URLEncoder;
import java.net.MalformedURLException;
import java.io.IOException;
import java.net.URL;
import javax.swing.text.*;
import javax.swing.*;


/**
 * A view that supports the &lt;ISINDEX&lt; tag.  This is implemented
 * as a JPanel that contains 
 *
 * @author Sunita Mani
 * @version 1.10, 01/23/03
 */

class IsindexView extends ComponentView implements ActionListener {
 
    JTextField textField;

    /**
     * Creates an IsindexView
     */
    public IsindexView(Element elem) {
	super(elem);
    }

    /**
     * Creates the components necessary to to implement
     * this view.  The component returned is a <code>JPanel</code>,
     * that contains the PROMPT to the left and <code>JTextField</code>
     * to the right.
     */
    public Component createComponent() {
	AttributeSet attr = getElement().getAttributes();
	
	JPanel panel = new JPanel(new BorderLayout());
	panel.setBackground(null);
	
	String prompt = (String)attr.getAttribute(HTML.Attribute.PROMPT);
	if (prompt == null) {
            prompt = UIManager.getString("IsindexView.prompt");
	}
	JLabel label = new JLabel(prompt);

	textField = new JTextField();
	textField.addActionListener(this);
	panel.add(label, BorderLayout.WEST);
	panel.add(textField, BorderLayout.CENTER);
	panel.setAlignmentY(1.0f);
	panel.setOpaque(false);
	return panel;
    }

    /**
     * Responsible for processing the ActionEvent.
     * In this case this is hitting enter/return
     * in the text field.  This will construct the
     * URL from the base URL of the document.
     * To the URL is appended a '?' followed by the
     * contents of the JTextField.  The search 
     * contents are URLEncoded.
     */
    public void actionPerformed(ActionEvent evt) {

	String data = textField.getText();
	if (data != null) {
	    data = URLEncoder.encode(data);
	}


	AttributeSet attr = getElement().getAttributes();
	HTMLDocument hdoc = (HTMLDocument)getElement().getDocument();

	String action = (String) attr.getAttribute(HTML.Attribute.ACTION);
	if (action == null) {
	    action = hdoc.getBase().toString();
	}
	try {
	    URL url = new URL(action+"?"+data);
	    JEditorPane pane = (JEditorPane)getContainer();
	    pane.setPage(url);
	} catch (MalformedURLException e1) {
	} catch (IOException e2) {
	}
    }
}
