/*
 * @(#)src/classes/sov/javax/swing/plaf/metal/MetalToolBarUI.java, swing, as142, 20050517 1.15.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2003, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */
/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 63757  050903 slattery  Add IBM module header; 
 * 65304  301003 chenerys  Fix rollover border painting for JButtons
 * 69068  240204 jury      Button is not accepting border as null
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)MetalToolBarUI.java	1.33 03/01/23
 *
 */

package javax.swing.plaf.metal;

import javax.swing.*;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.*;

import java.beans.PropertyChangeListener;

import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

/**
 * A Metal Look and Feel implementation of ToolBarUI.  This implementation 
 * is a "combined" view/controller.
 * <p>
 *
 * @version 1.33 01/23/03
 * @author Jeff Shapiro
 */
public class MetalToolBarUI extends BasicToolBarUI
{
    /**
     * This protected field is implemenation specific. Do not access directly
     * or override. Use the create method instead.
     *
     * @see #createContainerListener
     */
    protected ContainerListener contListener;

    /**
     * This protected field is implemenation specific. Do not access directly
     * or override. Use the create method instead.
     *
     * @see #createRolloverListener
     */
    protected PropertyChangeListener rolloverListener;

    private static Border nonRolloverBorder;

    public static ComponentUI createUI( JComponent c )
    {
	return new MetalToolBarUI();
    }

    public void installUI( JComponent c )
    {
        super.installUI( c );
    }

    public void uninstallUI( JComponent c )
    {
        super.uninstallUI( c );
	nonRolloverBorder = null;
    }

    protected void installListeners() {
        super.installListeners();

	contListener = createContainerListener();
	if (contListener != null) {
	    toolBar.addContainerListener(contListener);
	}
	rolloverListener = createRolloverListener();
	if (rolloverListener != null) {
	    toolBar.addPropertyChangeListener(rolloverListener);
	}
    }

    protected void uninstallListeners() {
        super.uninstallListeners();

	if (contListener != null) {
	    toolBar.removeContainerListener(contListener);
	}
	rolloverListener = createRolloverListener();
	if (rolloverListener != null) {
	    toolBar.removePropertyChangeListener(rolloverListener);
	}
    }

    protected Border createRolloverBorder() {
        return new CompoundBorder(new MetalBorders.RolloverButtonBorder(),    /*ibm@65304*/
				  new MetalBorders.RolloverMarginBorder());
    }

    protected Border createNonRolloverBorder() {
        return new CompoundBorder(new MetalBorders.ButtonBorder(),            /*ibm@65304*/
				  new MetalBorders.RolloverMarginBorder());
    }


    /**
     * Creates a non rollover border for Toggle buttons in the toolbar.
     */
    private Border createNonRolloverToggleBorder() {
	return createNonRolloverBorder();
    }
    
    protected void setBorderToNonRollover(Component c) {
        /*ibm@65304 start*/
        if (c instanceof JToggleButton && !(c instanceof JCheckBox)) {
            JToggleButton b = (JToggleButton)c;
            Border border = b.getBorder();
            super.setBorderToNonRollover(c);
            if (border instanceof UIResource) { /*ibm@69068*/
                if (nonRolloverBorder == null) {
                    nonRolloverBorder = createNonRolloverToggleBorder();
		}
                b.setBorder(nonRolloverBorder);
	    }
        } else {
            super.setBorderToNonRollover(c);
        }
        /*ibm@65304 end*/
    }


    /**
     * Creates a container listener that will be added to the JToolBar.
     * If this method returns null then it will not be added to the 
     * toolbar.
     *
     * @return an instance of a <code>ContainerListener</code> or null
     */
    protected ContainerListener createContainerListener() {
	return null;
    }

    /**
     * Creates a property change listener that will be added to the JToolBar.
     * If this method returns null then it will not be added to the 
     * toolbar.
     *
     * @return an instance of a <code>PropertyChangeListener</code> or null
     */
    protected PropertyChangeListener createRolloverListener() {
	return null;
    }

    protected MouseInputListener createDockingListener( )
    {
	return new MetalDockingListener( toolBar );
    }

    protected void setDragOffset(Point p) {
	if (!GraphicsEnvironment.isHeadless()) {
	    if (dragWindow == null) {
		dragWindow = createDragWindow(toolBar);
	    }
	    dragWindow.setOffset(p);
	}
    }

    // No longer used. Cannot remove for compatibility reasons
    protected class MetalContainerListener
	extends BasicToolBarUI.ToolBarContListener {}

    // No longer used. Cannot remove for compatibility reasons
    protected class MetalRolloverListener 
	extends BasicToolBarUI.PropertyListener {}

    protected class MetalDockingListener extends DockingListener {
        private boolean pressedInBumps = false;

	public MetalDockingListener(JToolBar t) {
	    super(t);
	} 

	public void mousePressed(MouseEvent e) { 
	    super.mousePressed(e);
            if (!toolBar.isEnabled()) {
                return;
            }
	    pressedInBumps = false;
	    Rectangle bumpRect = new Rectangle();

	    if (toolBar.getOrientation() == JToolBar.HORIZONTAL) {
		int x = MetalUtils.isLeftToRight(toolBar) ? 0 : toolBar.getSize().width-14;
		bumpRect.setBounds(x, 0, 14, toolBar.getSize().height);
	    } else {  // vertical
		bumpRect.setBounds(0, 0, toolBar.getSize().width, 14);
	    }
	    if (bumpRect.contains(e.getPoint())) {
	        pressedInBumps = true;
                Point dragOffset = e.getPoint();
                if (!MetalUtils.isLeftToRight(toolBar)) {
                    dragOffset.x -= (toolBar.getSize().width 
				     - toolBar.getPreferredSize().width);
                }
                setDragOffset(dragOffset);
	    }
	}

	public void mouseDragged(MouseEvent e) {
	    if (pressedInBumps) {
	        super.mouseDragged(e);
	    }
	}
    } // end class MetalDockingListener
}
