/*
 * @(#)src/classes/sov/javax/swing/plaf/metal/MetalComboBoxUI.java, swing, as142, 20050517 1.19.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2003, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */
/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 56755  261102 mchapman  Accessibility fix for JComboBox
 * 63201  310703 prakashr  FVT:SunReg:DefaultKeySelectionManager throws NPE
 * 63757  050903 slattery  Add IBM module header; 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)MetalComboBoxUI.java	1.42 03/01/23
 *
 */

package javax.swing.plaf.metal;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.border.*;
import javax.swing.plaf.basic.*;
import java.io.Serializable;
import java.beans.*;


/**
 * Metal UI for JComboBox
 * <p>
 * <strong>Warning:</strong>
 * Serialized objects of this class will not be compatible with
 * future Swing releases. The current serialization support is
 * appropriate for short term storage or RMI between applications running
 * the same version of Swing.  As of 1.4, support for long term storage
 * of all JavaBeans<sup><font size="-2">TM</font></sup>
 * has been added to the <code>java.beans</code> package.
 * Please see {@link java.beans.XMLEncoder}.
 *
 * @see MetalComboBoxEditor
 * @see MetalComboBoxButton
 * @version 1.42 01/23/03
 * @author Tom Santos
 */
public class MetalComboBoxUI extends BasicComboBoxUI {

    private ActionListener editorActionListener;                /* ibm@56755 */

    public static ComponentUI createUI(JComponent c) {
        return new MetalComboBoxUI();
    }

    public void paint(Graphics g, JComponent c) {
    }

    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return new MetalComboPopup( comboBox );
    }

    /*ibm@56755 start*/
    protected KeyListener createKeyListener() {
        return new NoSelectKeyHandler();
    }
    private class NoSelectKeyHandler extends KeyAdapter {
        private int selectionForKey(char aKey) {
            int i,c;
            int currentSelection = -1;
            Object selectedItem = listBox.getSelectedValue();
            String v;
            String pattern;
            ListModel aModel = listBox.getModel();
            
            if ( selectedItem != null ) {
                
                for ( i=0,c=aModel.getSize();i<c;i++ ) {
                    if ( selectedItem == aModel.getElementAt(i) ) { /*ibm@63201*/
                        currentSelection  =  i;
                        break;
                    }
                    
                }
            }
            
            pattern = ("" + aKey).toLowerCase();
            aKey = pattern.charAt(0);
            
            for ( i = ++currentSelection, c = aModel.getSize() ; i < c ; i++ ) {
                if (aModel.getElementAt(i) != null && aModel.getElementAt(i).toString() != null) { /*ibm@63201*/
                    v = aModel.getElementAt(i).toString().toLowerCase();
                    if ( v.length() > 0 && v.charAt(0) == aKey )
                        return i;
                }
            }
            
            for ( i = 0 ; i < currentSelection ; i ++ ) {
                if (aModel.getElementAt(i) != null && aModel.getElementAt(i).toString() != null) { /*ibm@63201*/
                    v = aModel.getElementAt(i).toString().toLowerCase();
                    if ( v.length() > 0 && v.charAt(0) == aKey )
                        return i;
                }
            }
            return -1;
        }

        private boolean selectWithKeyCharNoAction(char keyChar) {
            int index = selectionForKey(keyChar);
            if ( index != -1 ) {
                // the popup has to be showing now, otherwise the selected item
                // will not be seen
                comboBox.setPopupVisible(true);
                listBox.setSelectedIndex(index);
                listBox.ensureIndexIsVisible(index);
                return true;
            } else {
                return false;
            }
        }

        public void keyPressed( KeyEvent e ) {
            if ( comboBox.isEnabled() &&
                 !isNavigationKey( e.getKeyCode() ) &&
                 isTypeAheadKey( e ) ) {

                if (comboBox.getKeySelectionManager() != null) {
                    if ( comboBox.selectWithKeyChar(e.getKeyChar()) ) {
                        e.consume();
                    }
                } else {
                    if (selectWithKeyCharNoAction(e.getKeyChar()) ) {
                        e.consume();
                    }
                }
            }
        } 

        boolean isTypeAheadKey( KeyEvent e ) {
            return !e.isAltDown() && !e.isControlDown() && !e.isMetaDown();
        }
    }
    
    protected void selectNextPossibleValue() {
        int si = listBox.getSelectedIndex();
        if ( si < comboBox.getModel().getSize() - 1 ) {
            listBox.setSelectedIndex( si + 1 );
            listBox.ensureIndexIsVisible( si + 1 );
            comboBox.repaint();
        }
    }
    protected void selectPreviousPossibleValue() {
        int si = listBox.getSelectedIndex();
        if ( si > 0 ) {
            listBox.setSelectedIndex( si - 1 );
            listBox.ensureIndexIsVisible( si - 1 );
            comboBox.repaint();
        }
    }
    /*ibm@56755 end*/

    protected JButton createArrowButton() {
        JButton button = new MetalComboBoxButton( comboBox,
                                                  new MetalComboBoxIcon(),
                                                  comboBox.isEditable(),
                                                  currentValuePane,
                                                  listBox );
        button.setMargin( new Insets( 0, 1, 1, 3 ) );
        return button;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <FooUI>.
     */          
    public class MetalPropertyChangeListener extends BasicComboBoxUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange( e );
            String propertyName = e.getPropertyName();

            if ( propertyName.equals( "editable" ) ) {
		MetalComboBoxButton button = (MetalComboBoxButton)arrowButton;
		button.setIconOnly( comboBox.isEditable() );
		comboBox.repaint();
            } else if ( propertyName.equals( "background" ) ) {
                Color color = (Color)e.getNewValue();
                arrowButton.setBackground(color);
                listBox.setBackground(color);
                
            } else if ( propertyName.equals( "foreground" ) ) {
                Color color = (Color)e.getNewValue();
                arrowButton.setForeground(color);
                listBox.setForeground(color);
            }
        }
    }

    /**
     * As of Java 2 platform v1.4 this method is no longer used. Do not call or
     * override. All the functionality of this method is in the
     * MetalPropertyChangeListener.
     *
     * @deprecated As of Java 2 platform v1.4.
     */
    protected void editablePropertyChanged( PropertyChangeEvent e ) { }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <FooUI>.
     */          
    public class MetalComboBoxLayoutManager extends BasicComboBoxUI.ComboBoxLayoutManager {
        public void layoutContainer( Container parent ) {
            layoutComboBox( parent, this );
        }
        public void superLayout( Container parent ) {
            super.layoutContainer( parent );
        }
    }

    // This is here because of a bug in the compiler.  
    // When a protected-inner-class-savvy compiler comes out we
    // should move this into MetalComboBoxLayoutManager.
    public void layoutComboBox( Container parent, MetalComboBoxLayoutManager manager ) {
        if ( comboBox.isEditable() ) {
            manager.superLayout( parent );
        }
        else {
            if ( arrowButton != null ) {
                Insets insets = comboBox.getInsets();
                int width = comboBox.getWidth();
                int height = comboBox.getHeight();
                arrowButton.setBounds( insets.left, insets.top,
                                       width - (insets.left + insets.right),
                                       height - (insets.top + insets.bottom) );
            }
        }
    }

    /**
     * As of Java 2 platform v1.4 this method is no
     * longer used.
     *
     * @deprecated As of Java 2 platform v1.4.
     */
    protected void removeListeners() {
        if ( propertyChangeListener != null ) {
            comboBox.removePropertyChangeListener( propertyChangeListener );
        }
    }

    // These two methods were overloaded and made public. This was probably a
    // mistake in the implementation. The functionality that they used to 
    // provide is no longer necessary and should be removed. However, 
    // removing them will create an uncompatible API change.


    public void configureEditor() {
	super.configureEditor();
        if (editorActionListener == null) {                      /* ibm@56755 */
            editorActionListener = new ActionListener() {        /* ibm@56755 */
                    public void actionPerformed(ActionEvent e) { /* ibm@56755 */
                        if (isPopupVisible(comboBox)) {          /* ibm@56755 */
                            comboBox.setSelectedIndex(           /* ibm@56755 */
                                    listBox.getSelectedIndex()); /* ibm@56755 */
                        }                                        /* ibm@56755 */
                    }                                            /* ibm@56755 */
                };                                               /* ibm@56755 */
            comboBox.getEditor().addActionListener(              /* ibm@56755 */
                                         editorActionListener);  /* ibm@56755 */
        }                                                        /* ibm@56755 */
    }

    public void unconfigureEditor() {
	super.unconfigureEditor();
        if (editorActionListener != null) {                      /* ibm@56755 */
            (comboBox.getEditor()).removeActionListener(         /* ibm@56755 */
                                          editorActionListener); /* ibm@56755 */
            editorActionListener = null;                         /* ibm@56755 */
        }                                                        /* ibm@56755 */
    }
 
    public Dimension getMinimumSize( JComponent c ) {
        if ( !isMinimumSizeDirty ) {
            return new Dimension( cachedMinimumSize );
        }

        Dimension size = null;

        if ( !comboBox.isEditable() &&
             arrowButton != null &&
             arrowButton instanceof MetalComboBoxButton ) {

            MetalComboBoxButton button = (MetalComboBoxButton)arrowButton;
            Insets buttonInsets = button.getInsets();
            Insets insets = comboBox.getInsets();

            size = getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonInsets.right + button.getComboIcon().getIconWidth();
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
        }
        else if ( comboBox.isEditable() &&
                  arrowButton != null &&
                  editor != null ) {
            size = super.getMinimumSize( c );
            Insets margin = arrowButton.getMargin();
            size.height += margin.top + margin.bottom;
            size.width += margin.left + margin.right;
        }
        else {
            size = super.getMinimumSize( c );
        }

        cachedMinimumSize.setSize( size.width, size.height ); 
        isMinimumSizeDirty = false;

        return new Dimension( cachedMinimumSize );
    }

    /**
     * This inner class is marked &quot;public&quot; due to a compiler bug.
     * This class should be treated as a &quot;protected&quot; inner class.
     * Instantiate it only within subclasses of <FooUI>.
     *
     * This class is now obsolete and doesn't do anything and
     * is only included for backwards API compatibility. Do not call or 
     * override.
     * 
     * @deprecated As of Java 2 platform v1.4.
     */          
    public class MetalComboPopup extends BasicComboPopup {

	public MetalComboPopup( JComboBox cBox) {
	    super( cBox );
	}

	// This method was overloaded and made public. This was probably
	// mistake in the implementation. The functionality that they used to 
	// provide is no longer necessary and should be removed. However, 
	// removing them will create an uncompatible API change.

	public void delegateFocus(MouseEvent e) {
	    super.delegateFocus(e);
	}
    }
}


