/*
 * @(#)src/classes/sov/javax/sound/midi/Receiver.java, audio, as142, 20050517 1.16.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1996, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */

/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 064453  101003 prakashr  Add IBM module header
 *
 * ===========================================================================
 *
 */

/*
 * @(#)Receiver.java	1.19 03/01/27
 *
 */

package javax.sound.midi;		  	 


/**
 * A <code>Receiver</code> receives <code>{@link MidiEvent}</code> objects and
 * typically does something useful in response, such as interpreting them to
 * generate sound or raw MIDI output.  Common MIDI receivers include 
 * synthesizers and MIDI Out ports.  
 *
 * @see MidiDevice
 * @see Synthesizer
 * @see Transmitter
 *
 * @version 1.19, 03/01/27
 * @author Kara Kytle
 */
public interface Receiver {


    //$$fb 2002-04-12: fix for 4662090: Contradiction in Receiver specification
    /**
     * Sends a MIDI message and time-stamp to this receiver.
     * If time-stamping is not supported by this receiver, the time-stamp 
     * value should be -1.
     * @param message the MIDI message to send
     * @param timeStamp the time-stamp for the message, in microseconds.
     * @throws IllegalStateException if the receiver is closed
     */ 
    public void send(MidiMessage message, long timeStamp);													 
	
    /**
     * Indicates that the application has finished using the receiver, and
     * that limited resources it requires may be released or made available.
     * Invoking methods on a receiver which has been closed may cause an 
     * <code>IllegalArgumentException</code> or other exception to be thrown.
     */
    public void close();
}
