/*
 * @(#)src/classes/sov/javax/naming/NameAlreadyBoundException.java, jndi, as142, 20050517 1.6.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */





package javax.naming;

/**
  * This exception is thrown by methods to indicate that
  * a binding cannot be added because the name is already bound to
  * another object.
  * <p>
  * Synchronization and serialization issues that apply to NamingException
  * apply directly here.
  *
  * @author Rosanna Lee
  * @author Scott Seligman
  * @version 1.3 99/12/04
  *
  * @see Context#bind
  * @see Context#rebind
  * @see Context#createSubcontext
  * @see javax.naming.directory.DirContext#bind
  * @see javax.naming.directory.DirContext#rebind
  * @see javax.naming.directory.DirContext#createSubcontext
  * @since 1.3
  */

public class NameAlreadyBoundException extends NamingException {
    /**
     * Constructs a new instance of NameAlreadyBoundException using the
     * explanation supplied. All other fields default to null.
     *
     *
     * @param	explanation	Possibly null additional detail about this exception.
     * @see java.lang.Throwable#getMessage
     */
    public NameAlreadyBoundException(String explanation) {
	super(explanation);
    }

    /**
      * Constructs a new instance of NameAlreadyBoundException.
      * All fields are set to null;
      */
    public NameAlreadyBoundException() {
	super();
    }

    /**
     * Use serialVersionUID from JNDI 1.1.1 for interoperability
     */
    private static final long serialVersionUID = -8491441000356780586L;
}
