/*
 * @(#)src/classes/sov/javax/accessibility/Accessible.java, accessibility, as142, 20050517 1.12.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2003, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */
/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 63757  050903 slattery  Add IBM module header; 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)Accessible.java	1.35 03/01/23
 *
 */

package javax.accessibility;

/**
 * Interface Accessible is the main interface for the accessibility package. 
 * All components that support
 * the accessibility package must implement this interface.  
 * It contains a single method, {@link #getAccessibleContext}, which  
 * returns an instance of the class {@link AccessibleContext}.
 *
 * @version     1.1 11/24/97 20:34:48
 * @author	Peter Korn
 * @author      Hans Muller
 * @author      Willie Walker
 */
public interface Accessible {

    /**
     * Returns the AccessibleContext associated with this object.  In most
     * cases, the return value should not be null if the object implements
     * interface Accessible.  If a component developer creates a subclass
     * of an object that implements Accessible, and that subclass
     * is not Accessible, the developer should override the 
     * getAccessibleContext method to return null.
     */
    public AccessibleContext getAccessibleContext();
}
