/*
 * @(#)src/classes/sov/java/text/WordBreakTable.java, i18n, as142, 20050517 1.8.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */





package java.text;

/**
 * This class implements a state transition table.
 * After each transition, using the get method, the
 * new state is returned along with information about
 * the state change (ex. was it a "marked" transition").
 * This class is internal only.
 */
final class WordBreakTable
{
    /**
     * Construct a table using existing data.  See SentenceBreakBoundary and
     * the other SimpleTextBoundary subclasses for examples.
     * @param cols number of columns in the table
     * @param data an encoded byte array containing state and transition data
     */
    public WordBreakTable(int cols, byte data[])
    {
        this.data = data;
        this.cols = cols;
    }

    /**
     * Get the resulting state moving from oldState accepting input
     * @param oldState current state
     * @param input input
     * @return int resulting state and transition data
     */
    public int get(int oldState, int input)
    {
        return data[(oldState & INDEX_MASK) * cols + input];
    }

    /**
     * Checks to see if the transition into the specified state was "marked"
     * @param state the state as returned by get, initialState, or endState
     * @return true if transition into state was marked.
     */
    public boolean isMarkState(int state)
    {
        return (state & MARK_MASK) != 0;
    }

    /**
     * Check is a state is the end state
     * @param state the state to check
     * @return true if state is an end state
     */
    public boolean isEndState(int state)
    {
        return (state & INDEX_MASK) == END_STATE;
    }

    /**
     * Get the start state
     * @return the initial state
     */
    public int initialState()
    {
        return INITIAL_STATE;
    }

    static final byte MARK_MASK = (byte)0x80;
    static final byte INDEX_MASK = (byte)0x7F;
    private static final int INITIAL_STATE = 1;
    private static final int END_STATE = 0;
    private byte data[];
    private int cols;
}

