/*
 * @(#)src/classes/sov/java/text/UnicodeClassMapping.java, i18n, as142, 20050517 1.8.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2001. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */





package java.text;

import java.lang.Character;
/**
 * This class maps categories to state change inputs for the
 * WordBreakTable.  An entire category is mapped to the same
 * value unless the character in question appears in the exception list.
 */
final class UnicodeClassMapping
{
    private int mappedValue[];
    private SpecialMapping exceptionChars[];
    private boolean hasException[];
    private int asciiValues[];

    /**
     * Create a mapping given a mapping from categories and a list
     * of exceptions.  Both the mapping list and exceptionChars list must
     * be sorted in ascending order.
     */
    public UnicodeClassMapping(int mappedValue[],
                               SpecialMapping exceptionChars[],
                               boolean hasException[],
                               int asciiValues[])
    {
        this.mappedValue = mappedValue;
        this.exceptionChars = exceptionChars;
        this.hasException = hasException;
        this.asciiValues = asciiValues;
    }

    /**
     * Map a character to a stage change input for WordBreakTable
     * @param ch The character to map.
     * @return The mapped value.
     */
    public int mappedChar(char ch)
    {
        if (ch <= 255)
            return asciiValues[ch];

        // get an appropriate category based on the character's Unicode class
        // if there's no entry in the exception table for that Unicode class,
        // we're done; otherwise we have to look in the exception table for
        // the character's category (\uffff is treated here as a sentinel
        // value meaning "end of the string"-- we always look in the exception
        // table for its category)
        int    charType = Character.getType(ch);
        if ((exceptionChars.length == 0) //|| (ch > '\u003f' && ch < '\u00a0')
                || (!hasException[charType] && ch != '\uffff')) {
            return mappedValue[charType];
        }

        //do binary search of exceptionChars table
        int min = 0;
        int max = exceptionChars.length - 1;
        while (max > min) {
            int pos = (max + min) >> 1;
            if (ch > exceptionChars[pos].endChar)
                min = pos + 1;
            else
                max = pos;
        }
        SpecialMapping sm = exceptionChars[min];
        if (sm.startChar <= ch && ch <= sm.endChar)
            return sm.newValue;
        else
            return mappedValue[charType];
    }
}

