/*
 * @(#)src/classes/sov/java/sql/Time.java, jdbc, as142, 20050517 1.12.2.2
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */

/*
 *
 * Change activity:
 *
 * Reason  Date     Origin   Description 
 * ------  -------- ------   ---------------------------------------------------- 
 * 084388  20050329 vsuswara Fix for updating Time  by settime method
*/
  


package java.sql;

import com.ibm.jvm.DateCache;                                      /*ibm@62015*/

/**
 * <P>A thin wrapper around the <code>java.util.Date</code> class that allows the JDBC
 * API to identify this as an SQL <code>TIME</code> value. The <code>Time</code>
 * class adds formatting and
 * parsing operations to support the JDBC escape syntax for time
 * values. 
 * <p>The date components should be set to the "zero epoch"
 * value of January 1, 1970 and should not be accessed. 
 */
public class Time extends java.util.Date {

    static final long serialVersionUID = 8397324403548013681L;     /*ibm@59794*/

    private transient DateCache cache;                             /*ibm@59794*/

    /**
     * Constructs a <code>Time</code> object initialized with the 
     * given values for the hour, minute, and second.
     * The driver sets the date components to January 1, 1970.
     * Any method that attempts to access the date components of a
     * <code>Time</code> object will throw a
     * <code>java.lang.IllegalArgumentException</code>.
     * <P>
     * The result is undefined if a given argument is out of bounds.
     *
     * @param hour 0 to 23
     * @param minute 0 to 59
     * @param second 0 to 59
     *
     * @deprecated Use the constructor that takes a milliseconds value
     *             in place of this constructor
     */
    public Time(int hour, int minute, int second) {
	super(70, 0, 1, hour, minute, second);
        cache = DateCache.hms(hour, minute, second);              /*ibm@59794*/
    }
   
    /**
     * Constructs a <code>Time</code> object using a milliseconds time value.
     *
     * @param time milliseconds since January 1, 1970, 00:00:00 GMT;
     *             a negative number is milliseconds before
     *               January 1, 1970, 00:00:00 GMT
     */
    public Time(long time) {
	super(time);
    }

    /**
     * Sets a <code>Time</code> object using a milliseconds time value.
     *
     * @param time milliseconds since January 1, 1970, 00:00:00 GMT;
     *             a negative number is milliseconds before
     *               January 1, 1970, 00:00:00 GMT
     */
    public void setTime(long time) {
	super.setTime(time);
        cache = null;                                             /*ibm@59794*/
    }

    public int getHours()                                         /*ibm@59794*/
    {                                                             /*ibm@59794*/
        if (cache == null)                                        /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return super.getHours();                              /*ibm@59794*/
        }                                                         /*ibm@59794*/
        else                                                      /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return cache.hour;                                    /*ibm@59794*/
        }                                                         /*ibm@59794*/
    }                                                             /*ibm@59794*/

    public int getMinutes()                                       /*ibm@59794*/
    {                                                             /*ibm@59794*/
        if (cache == null)                                        /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return super.getMinutes();                            /*ibm@59794*/
        }                                                         /*ibm@59794*/
        else                                                      /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return cache.minute;                                  /*ibm@59794*/
        }                                                         /*ibm@59794*/
    }                                                             /*ibm@59794*/

    public int getSeconds()                                       /*ibm@59794*/
    {                                                             /*ibm@59794*/
        if (cache == null)                                        /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return super.getSeconds();                            /*ibm@59794*/
        }                                                         /*ibm@59794*/
        else                                                      /*ibm@59794*/
        {                                                         /*ibm@59794*/
            return cache.second;                                  /*ibm@59794*/
        }                                                         /*ibm@59794*/
    }                                                             /*ibm@59794*/


    /*
    * @deprecated As of JDK version 1.1,
    */

    public void setHours(int hours)                                /*ibm@84388*/
    {                                                              /*ibm@84388*/
        super.setHours(hours);                                     /*ibm@84388*/ 
        cache = null;                                              /*ibm@84388*/
    }                                                              /*ibm@84388*/

    public void setMinutes(int minutes)                            /*ibm@84388*/
    {                                                              /*ibm@84388*/
        super.setMinutes(minutes);                                 /*ibm@84388*/
        cache = null;                                              /*ibm@84388*/
    }                                                              /*ibm@84388*/

    public void setSeconds(int seconds)                             /*ibm@84388*/
    {                                                               /*ibm@84388*/
        super.setSeconds(seconds);                                  /*ibm@84388*/
        cache = null;                                               /*ibm@84388*/
    }                                                               /*ibm@84388*/



    /**
     * Converts a string in JDBC time escape format to a <code>Time</code> value.
     *
     * @param s time in format "hh:mm:ss"
     * @return a corresponding <code>Time</code> object
     */
    public static Time valueOf(String s) {
	int hour;
	int minute;
	int second;
	int firstColon;
	int secondColon;

	if (s == null) throw new java.lang.IllegalArgumentException();

	firstColon = s.indexOf(':');
	secondColon = s.indexOf(':', firstColon+1);
	if ((firstColon > 0) & (secondColon > 0) & 
	    (secondColon < s.length()-1)) {
	    hour = Integer.parseInt(s.substring(0, firstColon));
	    minute = 
		Integer.parseInt(s.substring(firstColon+1, secondColon));
	    second = Integer.parseInt(s.substring(secondColon+1));	    
	} else {
	    throw new java.lang.IllegalArgumentException();
	}

	return new Time(hour, minute, second);
    }
   
    /**
     * Formats a time in JDBC time escape format.  
     *
     * @return a <code>String</code> in hh:mm:ss format
     */
    public String toString () {

        int hour;                                                 /*ibm@59794*/
        int minute;                                               /*ibm@59794*/
        int second;                                               /*ibm@59794*/
        String hourString;                                        
        String minuteString;
        String secondString;                               
    
        if (cache == null)                                        /*ibm@59794*/
        {                                                         /*ibm@59794*/
            hour = super.getHours();                              /*ibm@59794*/
            minute = super.getMinutes();                          /*ibm@59794*/
            second = super.getSeconds();                          /*ibm@59794*/
        }                                                         /*ibm@59794*/
        else                                                      /*ibm@59794*/
        {                                                         /*ibm@59794*/
            hour = cache.hour;                                    /*ibm@59794*/
            minute = cache.minute;                                /*ibm@59794*/
            second = cache.second;                                /*ibm@59794*/
        }                                                         /*ibm@59794*/
        
        if (hour < 10) {
            hourString = "0" + hour;
        } else {
            hourString = Integer.toString(hour);
        }
        if (minute < 10) {
            minuteString = "0" + minute;
        } else {
            minuteString = Integer.toString(minute);
        }
        if (second < 10) {
            secondString = "0" + second;
        } else {
            secondString = Integer.toString(second);
        }
        return (hourString + ":" + minuteString + ":" + secondString);
    }

    // Override all the date operations inherited from java.util.Date;

   /**
    * This method is deprecated and should not be used because SQL <code>TIME</code> 
    * values do not have a year component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this
    *           method is invoked
    * @see #setYear
    */
    public int getYear() {
	throw new java.lang.IllegalArgumentException();
    }

   /**
    * This method is deprecated and should not be used because SQL <code>TIME</code> 
    * values do not have a month component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this
    *           method is invoked
    * @see #setMonth
    */
    public int getMonth() {
	throw new java.lang.IllegalArgumentException();
    }
    
   /**
    * This method is deprecated and should not be used because SQL <code>TIME</code> 
    * values do not have a day component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this
    *           method is invoked
    */
    public int getDay() {
	throw new java.lang.IllegalArgumentException();
    }

   /**
    * This method is deprecated and should not be used because SQL <code>TIME</code> 
    * values do not have a date component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this
    *           method is invoked
    * @see #setDate
    */
    public int getDate() {
	throw new java.lang.IllegalArgumentException();
    }

   /**
    * This method is deprecated and should not be used because SQL <code>TIME</code> 
    * values do not have a year component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this
    *           method is invoked
    * @see #getYear
    */
    public void setYear(int i) {
	throw new java.lang.IllegalArgumentException();
    }

   /**
    * This method is deprecated and should not be used because SQL <code>TIME</code> 
    * values do not have a month component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this
    *           method is invoked
    * @see #getMonth
    */
    public void setMonth(int i) {
	throw new java.lang.IllegalArgumentException();
    }

   /**
    * This method is deprecated and should not be used because SQL <code>TIME</code> 
    * values do not have a date component.
    *
    * @deprecated
    * @exception java.lang.IllegalArgumentException if this
    *           method is invoked
    * @see #getDate
    */
    public void setDate(int i) {
	throw new java.lang.IllegalArgumentException();
    }
}



