/*
 * @(#)src/classes/sov/java/sql/Ref.java, jdbc, as142, 20050517 1.11.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */




package java.sql;
 
/**
 * The mapping in the Java programming language of an SQL <code>REF</code>
 * value, which is a reference to an SQL structured type value in the database.
 * <P>
 * SQL <code>REF</code> values are stored in a table that contains
 * instances of a referenceable SQL structured type, and each <code>REF</code>
 * value is a unique identifier for one instance in that table. 
 * An SQL <code>REF</code> value may be used in place of the
 * SQL structured type it references, either as a column value in a
 * table or an attribute value in a structured type.
 * <P>
 * Because an SQL <code>REF</code> value is a logical pointer to an
 * SQL structured type, a <code>Ref</code> object is by default also a logical
 * pointer. Thus, retrieving an SQL <code>REF</code> value as
 * a <code>Ref</code> object does not materialize
 * the attributes of the structured type on the client.
 * <P>
 * A <code>Ref</code> object can be stored in the database using the 
 * <code>PreparedStatement.setRef</code> method.
 * 
 * @see Struct
 * @since 1.2
 */
public interface Ref {

    /**
     * Retrieves the fully-qualified SQL name of the SQL structured type that
     * this <code>Ref</code> object references.
     * 
     * @return the fully-qualified SQL name of the referenced SQL structured type 
     * @exception SQLException if a database access error occurs
     * @since 1.2
     */
    String getBaseTypeName() throws SQLException;

    /**
     * Retrieves the referenced object and maps it to a Java type
     * using the given type map.
     *
     * @param map a <code>java.util.Map</code> object that contains 
     *        the mapping to use (the fully-qualified name of the SQL
     *        structured type being referenced and the class object for
     *        <code>SQLData</code> implementation to which the SQL
     *        structured type will be mapped)
     * @return  a Java <code>Object</code> that is the custom mapping for 
     *          the SQL structured type to which this <code>Ref</code>
     *          object refers
     * @exception SQLException if a database access error occurs
     * @since 1.4
     * @see #setObject
     */
    Object getObject(java.util.Map map) throws SQLException;


    /**
     * Retrieves the SQL structured type instance referenced by
     * this <code>Ref</code> object.  If the connection's type map has an entry
     * for the structured type, the instance will be custom mapped to
     * the Java class indicated in the type map.  Otherwise, the
     * structured type instance will be mapped to a <code>Struct</code> object.
     *
     * @return  a Java <code>Object</code> that is the mapping for 
     *          the SQL structured type to which this <code>Ref</code>
     *          object refers
     * @exception SQLException if a database access error occurs
     * @since 1.4
     * @see #setObject
     */   
    Object getObject() throws SQLException;

    /**
     * Sets the structured type value that this <code>Ref</code>
     * object references to the given instance of <code>Object</code>.
     * The driver converts this to an SQL structured type when it
     * sends it to the database.
     *
     * @param value an <code>Object</code> representing the SQL 
     *        structured type instance that this
     *        <code>Ref</code> object will reference
     * @exception SQLException if a database access error occurs
     * @since 1.4
     * @see #getObject()
     * @see #getObject(Map)
     * @see PreparedStatement#setObject(int, Object)
     * @see CallableStatement#setObject(String, Object)
     */
    void setObject(Object value) throws SQLException;

}


