/*
 * @(#)src/classes/sov/java/rmi/server/RemoteServer.java, rmi, as142, 20050517 1.13.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2003. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


package java.rmi.server;

import java.rmi.*;
import com.ibm.jvm.ExtendedSystem;                                    /*SHIRAZ*/
import sun.rmi.server.UnicastServerRef;
import sun.rmi.runtime.Log;

/**
 * The <code>RemoteServer</code> class is the common superclass to server
 * implementations and provides the framework to support a wide range
 * of remote reference semantics.  Specifically, the functions needed
 * to create and export remote objects (i.e. to make them remotely
 * available) are provided abstractly by <code>RemoteServer</code> and
 * concretely by its subclass(es).
 *
 * @version 1.30, 03/21/02
 * @author  Ann Wollrath
 * @since   JDK1.1
 */
public abstract class RemoteServer extends RemoteObject
{
    /* indicate compatibility with JDK 1.1.x version of class */
    private static final long serialVersionUID = -4100238210092549637L;

    /**
     * Constructs a <code>RemoteServer</code>.
     * @since JDK1.1
     */
    protected RemoteServer() {
	super();
    }

    /**
     * Constructs a <code>RemoteServer</code> with the given reference type.
     *
     * @param ref the remote reference
     * @since JDK1.1
     */
    protected RemoteServer(RemoteRef ref) {
	super(ref);
    }

    /**
     * Returns a string representation of the client host for the
     * remote method invocation being processed in the current thread.
     *
     * @return 	a string representation of the client host
     *
     * @throws	ServerNotActiveException if no remote method invocation
     * is being processed in the current thread
     *
     * @since	JDK1.1
     */
    public static String getClientHost() throws ServerNotActiveException {
	return sun.rmi.transport.tcp.TCPTransport.getClientHost();
    }

    /**
     * Log RMI calls to the output stream <code>out</code>. If
     * <code>out</code> is <code>null</code>, call logging is turned off.
     *
     * <p>If there is a security manager, its
     * <code>checkPermission</code> method will be invoked with a
     * <code>java.util.logging.LoggingPermission("control")</code>
     * permission; this could result in a <code>SecurityException</code>.
     *
     * @param	out the output stream to which RMI calls should be logged
     * @throws	SecurityException  if there is a security manager and
     * 		the invocation of its <code>checkPermission</code> method
     *		fails
     * @see #getLog
     * @since JDK1.1
     */
    public static void setLog(java.io.OutputStream out) 
    {
	logNull = (out == null);
	UnicastServerRef.callLog.setOutputStream(out);
        ExtendedSystem.setJVMUnresettableConditionally(               /*SHIRAZ*/
            ExtendedSystem.SCJVM_MODIFYING_STATIC,
            new String("Modified log in RemoteServer.setLog()"));/*ibm@25627*//*SHIRAZ*/
    }
    
    /**
     * Returns stream for the RMI call log.
     * @return the call log
     * @see #setLog
     * @since JDK1.1
     */
    public static java.io.PrintStream getLog() 
    {
	return (logNull ? null : UnicastServerRef.callLog.getPrintStream());
    }

    // initialize log status
    private static boolean logNull = !UnicastServerRef.logCalls;
}
