/*
 * @(#)src/classes/sov/java/nio/charset/UnsupportedCharsetException.java, i18n, as142, 20050517 1.2.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio.charset;

/**
 * Unchecked exception thrown when no support is available
 * for a requested charset.
 *
 * @version 1.2, 01/09/17
 * @since 1.4
 */

public class UnsupportedCharsetException extends IllegalArgumentException {

   private String charsetName;

   /**
    * Constructs an instance of this class. </p>
    *
    * @param  charsetName
    *         The name of the unsupported charset
    */
   public UnsupportedCharsetException(String charsetName) {
      super(String.valueOf(charsetName));
      this.charsetName = charsetName;
   }

   /**
    * Retrieves the name of the unsupported charset. </p>
    *
    * @return  The name of the unsupported charset
    */
   public String getCharsetName() {
      return charsetName;
   }

}
