/*
 * @(#)src/classes/sov/java/nio/HeapDoubleBufferR.java, nio, as142, 20050517 1.2.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


/*
 *
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 056105  111002 ktsui   Move Sovereign codebase to 1.4.1 for NIO, NET & IO
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio;

/**
 * A read-only HeapDoubleBuffer.  This class extends the corresponding
 * read/write class, overriding the mutation methods to throw a {@link
 * ReadOnlyBufferException} and overriding the view-buffer methods to return an
 * instance of this class rather than of the superclass.
 */

class HeapDoubleBufferR extends HeapDoubleBuffer {

   HeapDoubleBufferR(int cap, int lim) {

      super(cap, lim);
      this.isReadOnly = true;

   }

   HeapDoubleBufferR(double[] buf, int off, int len) {

      super(buf, off, len);
      this.isReadOnly = true;

   }

   protected HeapDoubleBufferR(double[] buf, int mark, int pos, int lim, int cap, int off) {

      super(buf, mark, pos, lim, cap, off);
      this.isReadOnly = true;

   }

   public DoubleBuffer slice() {
      return new HeapDoubleBufferR(
         hb,
         -1,
         0,
         this.remaining(),
         this.remaining(),
         this.position() + offset);
   }

   public DoubleBuffer duplicate() {
      return new HeapDoubleBufferR(
         hb,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         offset);
   }

   public DoubleBuffer asReadOnlyBuffer() {

      return duplicate();

   }

   public boolean isReadOnly() {
      return true;
   }

   public DoubleBuffer put(double x) {

      throw new ReadOnlyBufferException();

   }

   public DoubleBuffer put(int i, double x) {

      throw new ReadOnlyBufferException();

   }

   public DoubleBuffer put(double[] src, int offset, int length) {

      throw new ReadOnlyBufferException();

   }

   public DoubleBuffer put(DoubleBuffer src) {

      throw new ReadOnlyBufferException();

   }

   public DoubleBuffer compact() {

      throw new ReadOnlyBufferException();

   }

   public ByteOrder order() {
      return ByteOrder.nativeOrder();
   }

}
