/*
 * @(#)src/classes/sov/java/nio/HeapDoubleBuffer.java, nio, as142, 20050517 1.2.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


/*
 *
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 056105  111002 ktsui   Move Sovereign codebase to 1.4.1 for NIO, NET & IO
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio;

/**
 * A read/write HeapDoubleBuffer.
 */

class HeapDoubleBuffer extends DoubleBuffer {

   // For speed these fields are actually declared in X-Buffer;
   // these declarations are here as documentation
   //
   // protected final double[] hb;
   // protected final int offset;

   HeapDoubleBuffer(int cap, int lim) {

      super(-1, 0, lim, cap, new double[cap], 0);

   }

   HeapDoubleBuffer(double[] buf, int off, int len) {

      super(-1, off, off + len, buf.length, buf, 0);

   }

   protected HeapDoubleBuffer(double[] buf, int mark, int pos, int lim, int cap, int off) {

      super(mark, pos, lim, cap, buf, off);

   }

   public DoubleBuffer slice() {
      return new HeapDoubleBuffer(
         hb,
         -1,
         0,
         this.remaining(),
         this.remaining(),
         this.position() + offset);
   }

   public DoubleBuffer duplicate() {
      return new HeapDoubleBuffer(
         hb,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         offset);
   }

   public DoubleBuffer asReadOnlyBuffer() {

      return new HeapDoubleBufferR(
         hb,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         offset);

   }

   protected int ix(int i) {
      return i + offset;
   }

   public double get() {
      return hb[ix(nextGetIndex())];
   }

   public double get(int i) {
      return hb[ix(checkIndex(i))];
   }

   public DoubleBuffer get(double[] dst, int offset, int length) {
      checkBounds(offset, length, dst.length);
      if (length > remaining())
         throw new BufferUnderflowException();
      System.arraycopy(hb, ix(position()), dst, offset, length);
      position(position() + length);
      return this;
   }

   public boolean isDirect() {
      return false;
   }

   public boolean isReadOnly() {
      return false;
   }

   public DoubleBuffer put(double x) {

      hb[ix(nextPutIndex())] = x;
      return this;

   }

   public DoubleBuffer put(int i, double x) {

      hb[ix(checkIndex(i))] = x;
      return this;

   }

   public DoubleBuffer put(double[] src, int offset, int length) {

      checkBounds(offset, length, src.length);
      if (length > remaining())
         throw new BufferOverflowException();
      System.arraycopy(src, offset, hb, ix(position()), length);
      position(position() + length);
      return this;

   }

   public DoubleBuffer put(DoubleBuffer src) {

      if (src instanceof HeapDoubleBuffer) {
         if (src == this)
            throw new IllegalArgumentException();
         HeapDoubleBuffer sb = (HeapDoubleBuffer) src;
         int n = sb.remaining();
         if (n > remaining())
            throw new BufferOverflowException();
         System.arraycopy(sb.hb, sb.ix(sb.position()), hb, ix(position()), n);
         sb.position(sb.position() + n);
         position(position() + n);
      } else if (src.isDirect()) {
         int n = src.remaining();
         if (n > remaining())
            throw new BufferOverflowException();
         src.get(hb, ix(position()), n);
         position(position() + n);
      } else {
         super.put(src);
      }
      return this;

   }

   public DoubleBuffer compact() {

      System.arraycopy(hb, ix(position()), hb, ix(0), remaining());
      position(remaining());
      limit(capacity());
      return this;

   }

   public ByteOrder order() {
      return ByteOrder.nativeOrder();
   }

}
