/*
 * @(#)src/classes/sov/java/nio/DirectLongBufferRS.java, nio, as142, 20050517 1.5.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2001, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */



/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 056105  111002 ktsui   Move Sovereign codebase to 1.4.1 for NIO, NET & IO
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 * 061317  130603 pabbott Backport Sun 1.4.2 direct memory cleanup.
 *
 */

package java.nio;

import sun.nio.ch.DirectBuffer;

class DirectLongBufferRS extends DirectLongBufferS implements DirectBuffer {

   // For duplicates and slices
   //
   DirectLongBufferRS(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {

      super(db, mark, pos, lim, cap, off);

   }

   public LongBuffer slice() {
      int pos = this.position();
      int lim = this.limit();
      assert(pos <= lim);
      int rem = (pos <= lim ? lim - pos : 0);
      int off = (pos << 3);
      return new DirectLongBufferRS(this, -1, 0, rem, rem, off);
   }

   public LongBuffer duplicate() {
      return new DirectLongBufferRS(
         this,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         0);
   }

   public LongBuffer asReadOnlyBuffer() {

      return duplicate();

   }

   public LongBuffer put(long x) {

      throw new ReadOnlyBufferException();

   }

   public LongBuffer put(int i, long x) {

      throw new ReadOnlyBufferException();

   }

   public LongBuffer put(LongBuffer src) {

      throw new ReadOnlyBufferException();

   }

   public LongBuffer put(long[] src, int offset, int length) {

      throw new ReadOnlyBufferException();

   }

   public LongBuffer compact() {

      throw new ReadOnlyBufferException();

   }

   public boolean isDirect() {
      return true;
   }

   public boolean isReadOnly() {
      return true;
   }

   public ByteOrder order() {

      return (
         (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN)
            ? ByteOrder.LITTLE_ENDIAN
            : ByteOrder.BIG_ENDIAN);

   }

}
