/*
 * @(#)src/classes/sov/java/nio/ByteBufferAsShortBufferRB.java, nio, as142, 20050517 1.2.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio;

class ByteBufferAsShortBufferRB extends ByteBufferAsShortBufferB {

   ByteBufferAsShortBufferRB(ByteBuffer bb) {

      super(bb);

   }

   ByteBufferAsShortBufferRB(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {

      super(bb, mark, pos, lim, cap, off);

   }

   public ShortBuffer slice() {
      int pos = this.position();
      int lim = this.limit();
      assert(pos <= lim);
      int rem = (pos <= lim ? lim - pos : 0);
      int off = (pos << 1) + offset;
      return new ByteBufferAsShortBufferRB(bb, -1, 0, rem, rem, off);
   }

   public ShortBuffer duplicate() {
      return new ByteBufferAsShortBufferRB(
         bb,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         offset);
   }

   public ShortBuffer asReadOnlyBuffer() {

      return duplicate();

   }

   public ShortBuffer put(short x) {

      throw new ReadOnlyBufferException();

   }

   public ShortBuffer put(int i, short x) {

      throw new ReadOnlyBufferException();

   }

   public ShortBuffer compact() {

      throw new ReadOnlyBufferException();

   }

   public boolean isDirect() {
      return bb.isDirect();
   }

   public boolean isReadOnly() {
      return true;
   }

   public ByteOrder order() {

      return ByteOrder.BIG_ENDIAN;

   }

}
