/*
 * @(#)src/classes/sov/java/nio/ByteBufferAsDoubleBufferRL.java, nio, as142, 20050517 1.2.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio;

class ByteBufferAsDoubleBufferRL extends ByteBufferAsDoubleBufferL {

   ByteBufferAsDoubleBufferRL(ByteBuffer bb) {

      super(bb);

   }

   ByteBufferAsDoubleBufferRL(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {

      super(bb, mark, pos, lim, cap, off);

   }

   public DoubleBuffer slice() {
      int pos = this.position();
      int lim = this.limit();
      assert(pos <= lim);
      int rem = (pos <= lim ? lim - pos : 0);
      int off = (pos << 3) + offset;
      return new ByteBufferAsDoubleBufferRL(bb, -1, 0, rem, rem, off);
   }

   public DoubleBuffer duplicate() {
      return new ByteBufferAsDoubleBufferRL(
         bb,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         offset);
   }

   public DoubleBuffer asReadOnlyBuffer() {

      return duplicate();

   }

   public DoubleBuffer put(double x) {

      throw new ReadOnlyBufferException();

   }

   public DoubleBuffer put(int i, double x) {

      throw new ReadOnlyBufferException();

   }

   public DoubleBuffer compact() {

      throw new ReadOnlyBufferException();

   }

   public boolean isDirect() {
      return bb.isDirect();
   }

   public boolean isReadOnly() {
      return true;
   }

   public ByteOrder order() {

      return ByteOrder.LITTLE_ENDIAN;

   }

}
