/*
 * @(#)src/classes/sov/java/nio/ByteBufferAsCharBufferRB.java, nio, as142, 20050517 1.2.2.1
 * ===========================================================================
 * IBM Confidential
 * OCO Source Materials
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2004.
 *
 * The source code for this program is not published or otherwise divested of
 * its trade secrets, irrespective of what has been deposited with the U.S.
 * Copyright office.
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2002 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */


/*
 * ===========================================================================
 * Change activity:
 *
 * Reason  Date   Origin  Description
 * ------  ----   ------  ----------------------------------------------------
 * 061774  030603 pabbott Remove autogeneration of NIO source files.
 *
 */

package java.nio;

class ByteBufferAsCharBufferRB extends ByteBufferAsCharBufferB {

   ByteBufferAsCharBufferRB(ByteBuffer bb) {

      super(bb);

   }

   ByteBufferAsCharBufferRB(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {

      super(bb, mark, pos, lim, cap, off);

   }

   public CharBuffer slice() {
      int pos = this.position();
      int lim = this.limit();
      assert(pos <= lim);
      int rem = (pos <= lim ? lim - pos : 0);
      int off = (pos << 1) + offset;
      return new ByteBufferAsCharBufferRB(bb, -1, 0, rem, rem, off);
   }

   public CharBuffer duplicate() {
      return new ByteBufferAsCharBufferRB(
         bb,
         this.markValue(),
         this.position(),
         this.limit(),
         this.capacity(),
         offset);
   }

   public CharBuffer asReadOnlyBuffer() {

      return duplicate();

   }

   public CharBuffer put(char x) {

      throw new ReadOnlyBufferException();

   }

   public CharBuffer put(int i, char x) {

      throw new ReadOnlyBufferException();

   }

   public CharBuffer compact() {

      throw new ReadOnlyBufferException();

   }

   public boolean isDirect() {
      return bb.isDirect();
   }

   public boolean isReadOnly() {
      return true;
   }

   public String toString(int start, int end) {
      if ((end > limit()) || (start > end))
         throw new IndexOutOfBoundsException();
      try {
         int len = end - start;
         char[] ca = new char[len];
         CharBuffer cb = CharBuffer.wrap(ca);
         CharBuffer db = this.duplicate();
         db.position(start);
         db.limit(end);
         cb.put(db);
         return new String(ca);
      } catch (StringIndexOutOfBoundsException x) {
         throw new IndexOutOfBoundsException();
      }
   }

   // --- Methods to support CharSequence ---

   public CharSequence subSequence(int start, int end) {
      int len = length();
      int pos = position();
      assert(pos <= len);
      pos = (pos <= len ? pos : len);

      if ((start < 0) || (end > len) || (start > end))
         throw new IndexOutOfBoundsException();
      int sublen = end - start;
      int off = offset + ((pos + start) << 1);
      return new ByteBufferAsCharBufferRB(bb, -1, 0, sublen, sublen, off);
   }

   public ByteOrder order() {

      return ByteOrder.BIG_ENDIAN;

   }

}
