/*
 * @(#)src/classes/sov/java/beans/beancontext/BeanContextServicesListener.java, bean, as142, 20050517 1.8.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2002. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */




 

package java.beans.beancontext;

import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;


/**
 * The listener interface for receiving 
 * <code>BeanContextServiceAvailableEvent</code> objects. 
 * A class that is interested in processing a 
 * <code>BeanContextServiceAvailableEvent</code> implements this interface. 
 */
public interface BeanContextServicesListener extends BeanContextServiceRevokedListener {

    /**
     * The service named has been registered. getService requests for
     * this service may now be made.
     * @param bcsae the <code>BeanContextServiceAvailableEvent</code> 
     */
    void serviceAvailable(BeanContextServiceAvailableEvent bcsae);
}
