/*
 * @(#)src/classes/sov/java/beans/IdentityHashtable.java, bean, as142, 20050517 1.4.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 1998, 2002. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */



package java.beans;

import java.util.*; 

/*
 * @version 1.3 11/15/00
 * @author Philip Milne
 */

class IdentityHashtable extends HashMap { 
    // private InstanceWrapper hashtableNull = new InstanceWrapper();
    
    private class InstanceWrapper { 
        public Object o; 
        
        public InstanceWrapper(Object o) { 
            this.o = o; 
        }

        public boolean equals(Object o2) { 
            return (o2.getClass() == InstanceWrapper.class) && (o == ((InstanceWrapper)o2).o); 
        }

        public int hashCode() { 
            return System.identityHashCode(o); 
        }
    }

    public Object put(Object key, Object value) { 
        return super.put(new InstanceWrapper(key), value); 
    }

    public Object get(Object key) { 
        return super.get(new InstanceWrapper(key)); 
    }

    public Object remove(Object key) { 
        return super.remove(new InstanceWrapper(key)); 
    } 
}
















































