/*
 * @(#)src/classes/sov/java/awt/dnd/DnDConstants.java, awt-dnd, as142, 20050517 1.14.2.1
 * ===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 *
 * IBM SDK, Java(tm) 2 Technology Edition, v1.4.2
 * (C) Copyright IBM Corp. 2003, 2004. All Rights Reserved
 * ===========================================================================
 */

/*
 * ===========================================================================
 * Copyright 2003 Sun Microsystems, Inc. All rights reserved.
 * ===========================================================================
 */
/* 
 *
 * Change activity:
 *
 * Reason  Date   Origin    Description
 * ------  ----   ------    -------------------------------------------------- 
 * 63757  050903 slattery  Add IBM module header; 
 *
 * ===========================================================================
 * Module Information:
 * 
 * DESCRIPTION: IBM.WRITEME
 * ===========================================================================
 */

/*
 * @(#)DnDConstants.java	1.18 03/01/23
 *
 */

package java.awt.dnd;

/**
 * This class contains constant values representing
 * the type of action(s) to be performed by a Drag and Drop operation.
 * @version 	1.18, 01/23/03
 * @since 1.2
 */

public final class DnDConstants {

    private DnDConstants() {} // define null private constructor.

    /**
     * An <code>int</code> representing no action. 
     */
    public static final int ACTION_NONE		= 0x0;

    /**
     * An <code>int</code> representing a &quot;copy&quot; action.
     */
    public static final int ACTION_COPY		= 0x1;

    /**
     * An <code>int</code> representing a &quot;move&quot; action.
     */
    public static final int ACTION_MOVE		= 0x2;

    /**
     * An <code>int</code> representing a &quot;copy&quot; or 
     * &quot;move&quot; action.
     */
    public static final int ACTION_COPY_OR_MOVE	= ACTION_COPY | ACTION_MOVE;

    /**
     * An <code>int</code> representing a &quot;link&quot; action.
     *
     * The link verb is found in many, if not all native DnD platforms, and the
     * actual interpretation of LINK semantics is both platform
     * and application dependent. Broadly speaking, the
     * semantic is "do not copy, or move the operand, but create a reference
     * to it". Defining the meaning of "reference" is where ambiguity is
     * introduced.
     *
     * The verb is provided for completeness, but its use is not recommended
     * for DnD operations between logically distinct applications where 
     * misinterpretation of the operations semantics could lead to confusing
     * results for the user.
     */

    public static final int ACTION_LINK	        = 0x40000000;

    /**
     * An <code>int</code> representing a &quot;reference&quot; 
     * action (synonym for ACTION_LINK).
     */
    public static final int ACTION_REFERENCE    = ACTION_LINK;

}


