package com.ibm.oti.vm;

/**
 * This interface is used to describe a class which uses a block of
 * OS memory.
 *
 * <pre>
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corp. 1999, 2004  All Rights Reserved
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 * </pre>
 */
public interface OSMemoryAccessor {
/**
 * Return a long pointer to the start of the OS memory block.
 */
public long getPointer();

/**
 * Return a int representing the size of the block of OS memory.
 */
public int getSize();
}

