package com.ibm.oti.util;

/*
 * Licensed Materials - Property of IBM,
 * (c) Copyright IBM Corp. 1998, 2004  All Rights Reserved
 */

import java.io.UTFDataFormatException;

public final class Util {

	private static final boolean useNative = com.ibm.oti.vm.VM.useNatives();
	private static final String defaultEncoding;

	static {
		String encoding = System.getProperty("os.encoding");
		if (encoding != null) {
			try {
				"".getBytes(encoding);
			} catch (java.io.UnsupportedEncodingException e) {
				encoding = null;
			}
		}
		defaultEncoding = encoding;
	}

public static byte[] getBytes(String name) {
	if (defaultEncoding != null) {
		try {
			return name.getBytes(defaultEncoding);
		} catch (java.io.UnsupportedEncodingException e) {}
	}
	return name.getBytes();
}

public static String toString(byte[] bytes) {
	if (defaultEncoding != null) {
		try {
			return new String(bytes, 0, bytes.length, defaultEncoding);
		} catch (java.io.UnsupportedEncodingException e) {}
	}
	return new String(bytes, 0, bytes.length);
}

public static String toString(byte[] bytes, int offset, int length) {
	if (defaultEncoding != null) {
		try {
			return new String(bytes, offset, length, defaultEncoding);
		} catch (java.io.UnsupportedEncodingException e) {}
	}
	return new String(bytes, offset, length);
}

private static native String convertUTF8(byte[] buf, int offset, int utfSize);

public static String convertFromUTF8(byte[] buf, int offset, int utfSize) throws UTFDataFormatException {
	if (useNative) {
		String result = convertUTF8(buf, offset, utfSize);
		if (result != null) return result;
		throw new UTFDataFormatException();
	}
	return convertUTF8WithBuf(buf, new char[utfSize], offset, utfSize);
}

public static String convertUTF8WithBuf(byte[] buf, char[] out, int offset, int utfSize) throws UTFDataFormatException {
	int count = 0, s = 0, a;
	while (count < utfSize) {
		if ((out[s] = (char)buf[offset + count++]) < '\u0080') s++;
		else if (((a = out[s]) & 0xe0) == 0xc0) {
			if (count >= utfSize)
				throw new UTFDataFormatException(com.ibm.oti.util.Msg.getString("K0062", count));
			int b = buf[count++];
			if ((b & 0xC0) != 0x80)
				throw new UTFDataFormatException(com.ibm.oti.util.Msg.getString("K0062", (count-1)));
			out[s++] = (char) (((a & 0x1F) << 6) | (b & 0x3F));
		} else if ((a & 0xf0) == 0xe0) {
			if (count+1 >= utfSize)
				throw new UTFDataFormatException(com.ibm.oti.util.Msg.getString("K0063", (count+1)));
			int b = buf[count++];
			int c = buf[count++];
			if (((b & 0xC0) != 0x80) || ((c & 0xC0) != 0x80))
				throw new UTFDataFormatException(com.ibm.oti.util.Msg.getString("K0064", (count-2)));
			out[s++] = (char) (((a & 0x0F) << 12) | ((b & 0x3F) << 6) | (c & 0x3F));
		} else {
			throw new UTFDataFormatException(com.ibm.oti.util.Msg.getString("K0065", (count-1)));
		}
	}
	return new String(out, 0, s);
}

/**
 * <p>
 * '%' and two following hex digit characters are converted
 *     to the equivalent byte value.
 * All other characters are passed through unmodified.
 * <p>
 * e.g. "ABC %24%25" -> "ABC $%"
 *
 * @author		IBM
 * @version		initial
 *
 * @param		s java.lang.String
 *					The encoded string.
 * @return		java.lang.String
 *					The decoded version.
 */
public static String decode(String s, boolean convertPlus) {
	if (!convertPlus && s.indexOf('%') == -1) return s;
	StringBuffer result = new StringBuffer(s.length());
	java.io.ByteArrayOutputStream out = new java.io.ByteArrayOutputStream();
	for (int i = 0; i < s.length();) {
		char c = s.charAt(i);
		if (convertPlus && c == '+') result.append(' ');
		else if (c == '%') {
			out.reset();
			do {
				if (i + 2 >= s.length())
					throw new IllegalArgumentException(com.ibm.oti.util.Msg.getString("K01fe", i));
				int d1 = Character.digit(s.charAt(i+1), 16);
				int d2 = Character.digit(s.charAt(i+2), 16);
				if (d1 == -1 || d2 == -1)
					throw new IllegalArgumentException(com.ibm.oti.util.Msg.getString("K01ff", s.substring(i, i+3), String.valueOf(i)));
				out.write((byte)((d1 << 4) + d2));
				i += 3;
			} while (i < s.length() && s.charAt(i) == '%');
			result.append(out.toString());
			continue;
		} else result.append(c);
		i++;
	}
	return result.toString();
}

}
