/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.DisplayText;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Vector;

public final class NoticeReference
implements Cloneable {
    private DisplayText organization;
    private BigInteger[] noticeNumbers;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.NoticeReference";

    public NoticeReference(byte[] byArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "NoticeReference", (Object)byArray);
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue derValue = derInputStream.getDerValue();
        this.decode(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "NoticeReference");
        }
    }

    public NoticeReference(DisplayText displayText, BigInteger[] bigIntegerArray) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "NoticeReference", displayText, bigIntegerArray);
        }
        if (displayText == null) {
            if (debug != null) {
                debug.text(16384L, className, "NoticeReference", "organization not specified");
            }
            throw new IllegalArgumentException("organization not specified");
        }
        if (bigIntegerArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "NoticeReference", "noticeNumbers not specified");
            }
            throw new IllegalArgumentException("noticeNumbers not specified");
        }
        this.organization = displayText;
        this.noticeNumbers = (BigInteger[])bigIntegerArray.clone();
        if (debug != null) {
            debug.exit(16384L, className, "NoticeReference");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            NoticeReference noticeReference = new NoticeReference(derOutputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", noticeReference);
            }
            return new NoticeReference(derOutputStream.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.organization.encode(derOutputStream);
        DerOutputStream derOutputStream3 = new DerOutputStream();
        for (int i = 0; i < this.noticeNumbers.length; ++i) {
            derOutputStream3.putInteger(this.noticeNumbers[i]);
        }
        derOutputStream.write((byte)48, derOutputStream3);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "NoticeReference parsing error.  Expected sequence.");
            }
            throw new IOException("NoticeReference parsing error.  Expected sequence.");
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        this.organization = new DisplayText(derValue2.toByteArray());
        derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() == 48) {
            Vector<BigInteger> vector = new Vector<BigInteger>();
            if (derValue2.getData().available() == 0) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "NoticeReference parsing error.  Could not get notice numbers.");
                }
                throw new IOException("NoticeReference parsing error.  Could not get notice numbers.");
            }
            while (derValue2.getData().available() != 0) {
                BigInteger bigInteger = derValue2.getData().getInteger();
                vector.addElement(bigInteger);
            }
            if (vector.size() != 0) {
                this.noticeNumbers = new BigInteger[vector.size()];
                for (int i = 0; i < this.noticeNumbers.length; ++i) {
                    this.noticeNumbers[i] = (BigInteger)vector.elementAt(i);
                }
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "decode", "NoticeReference parsing error.  Expected notice numbers.");
            }
            throw new IOException("NoticeReference parsing error.  Expected notice numbers.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public boolean equals(Object object) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (!(object instanceof NoticeReference)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", false);
            }
            return false;
        }
        if (object == this) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            ((NoticeReference)object).encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "equals", exception);
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_4", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_5", true);
        }
        return true;
    }

    public DisplayText getOrganization() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getOrganization");
            debug.exit(16384L, (Object)className, "getOrganization", this.organization);
        }
        return this.organization;
    }

    public BigInteger[] getNoticeNumbers() {
        if (debug != null) {
            debug.entry(16384L, className, "getNoticeNumbers");
            debug.exit(16384L, (Object)className, "getNoticeNumbers", (BigInteger[])this.noticeNumbers.clone());
        }
        return (BigInteger[])this.noticeNumbers.clone();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "";
        string = string + "Notice Reference: [";
        string = string + "\r\n\torganization  : " + this.organization.toString();
        string = string + "\r\n\tnotice numbers: ";
        for (int i = 0; i < this.noticeNumbers.length; ++i) {
            string = string + "\r\n\t\t" + this.noticeNumbers[i];
        }
        string = string + "\r\n]";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }
}

