/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public final class HoldInstructionCodeExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.HoldInstructionCode";
    public static final String NAME = "HoldInstructionCode";
    public static final String NUMBER = "value";
    private ObjectIdentifier holdInstructionCode;
    private static final int[] None_data = new int[]{1, 2, 840, 10040, 2, 1};
    private static final int[] CallIssuer_data = new int[]{1, 2, 840, 10040, 2, 2};
    private static final int[] Reject_data = new int[]{1, 2, 840, 10040, 2, 3};
    public static ObjectIdentifier HoldInstructionNone_Id;
    public static ObjectIdentifier HoldInstructionCallIssuer_Id;
    public static ObjectIdentifier HoldInstructionReject_Id;
    private static Debug debug;
    private static String className;

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.holdInstructionCode == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(this.holdInstructionCode);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public HoldInstructionCodeExtension(ObjectIdentifier objectIdentifier) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "HoldInstructionCodeExtension", objectIdentifier);
        }
        this.setHoldInstructionCode(objectIdentifier);
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "HoldInstructionCodeExtension");
        }
    }

    public HoldInstructionCodeExtension(Boolean bl, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "HoldInstructionCodeExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
        this.critical = bl;
        int n = Array.getLength(object);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = Array.getByte(object, i);
        }
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        this.setHoldInstructionCode(derValue.getOID());
        if (debug != null) {
            debug.exit(16384L, className, "HoldInstructionCodeExtension");
        }
    }

    private void setHoldInstructionCode(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setHoldInstructionCode", objectIdentifier);
        }
        if (objectIdentifier == null) {
            if (debug != null) {
                debug.text(8192L, className, "setHoldInstructionCode", "holdInstructionCode not specified.");
            }
            throw new IllegalArgumentException("holdInstructionCode not specified.");
        }
        if (!(objectIdentifier.equals(HoldInstructionNone_Id) || objectIdentifier.equals(HoldInstructionCallIssuer_Id) || objectIdentifier.equals(HoldInstructionReject_Id))) {
            if (debug != null) {
                debug.text(8192L, className, "setHoldInstructionCode", "holdInstructionCode OID " + objectIdentifier.toString() + " is not valid.");
            }
            throw new IllegalArgumentException("holdInstructionCode OID " + objectIdentifier.toString() + " is not valid.");
        }
        this.holdInstructionCode = objectIdentifier;
        if (debug != null) {
            debug.exit(8192L, className, "setHoldInstructionCode");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(NUMBER)) {
            if (!(object instanceof ObjectIdentifier)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute must be of type ObjectIdentifier.");
                }
                throw new IOException("Attribute must be of type ObjectIdentifier.");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
        }
        this.setHoldInstructionCode((ObjectIdentifier)object);
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(NUMBER)) {
            if (this.holdInstructionCode == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_1", null);
                }
                return null;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", this.holdInstructionCode);
            }
            return this.holdInstructionCode;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(NUMBER)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:HoldInstructionCode.");
        }
        this.holdInstructionCode = null;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = super.toString() + "Hold Instruction Code: ";
        string = this.holdInstructionCode == null ? string + "null" : (this.isNone() ? string + "None" : (this.isCallIssuer() ? string + "CallIssuer" : (this.isReject() ? string + "Reject" : string + this.holdInstructionCode.toString())));
        string = string + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.HoldInstructionCode_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public boolean isNone() {
        if (debug != null) {
            debug.entry(16384L, className, "isNone");
        }
        if (this.holdInstructionCode == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isNone_1", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isNone_2", this.holdInstructionCode.equals(HoldInstructionNone_Id));
        }
        return this.holdInstructionCode.equals(HoldInstructionNone_Id);
    }

    public boolean isCallIssuer() {
        if (debug != null) {
            debug.entry(16384L, className, "isCallIssuer");
        }
        if (this.holdInstructionCode == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isCallIssuer_1", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isCallIssuer_2", this.holdInstructionCode.equals(HoldInstructionCallIssuer_Id));
        }
        return this.holdInstructionCode.equals(HoldInstructionCallIssuer_Id);
    }

    public boolean isReject() {
        if (debug != null) {
            debug.entry(16384L, className, "isReject");
        }
        if (this.holdInstructionCode == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isReject_1", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isReject_2", this.holdInstructionCode.equals(HoldInstructionReject_Id));
        }
        return this.holdInstructionCode.equals(HoldInstructionReject_Id);
    }

    static {
        debug = Debug.getInstance("ibmpkcs");
        className = "com.ibm.security.x509.HoldInstructionCodeExtension";
        try {
            HoldInstructionNone_Id = new ObjectIdentifier(None_data);
            HoldInstructionCallIssuer_Id = new ObjectIdentifier(CallIssuer_data);
            HoldInstructionReject_Id = new ObjectIdentifier(Reject_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

