/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Enumeration;

public final class CertificateX509Key
implements CertAttrSet {
    public static final String IDENT = "x509.info.key";
    public static final String NAME = "key";
    public static final String KEY = "value";
    private PublicKey key;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateX509Key";

    public CertificateX509Key(PublicKey publicKey) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateX509Key", publicKey);
            debug.exit(16384L, className, "CertificateX509Key");
        }
        this.key = publicKey;
    }

    public CertificateX509Key(PublicKey publicKey, String string) {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateX509Key", publicKey, string);
            debug.exit(16384L, className, "CertificateX509Key");
        }
        this.key = publicKey;
        if (string != null) {
            this.provider = new String(string);
        }
    }

    public CertificateX509Key(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateX509Key", derInputStream);
        }
        DerValue derValue = derInputStream.getDerValue();
        this.key = X509Key.parse(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateX509Key");
        }
    }

    public CertificateX509Key(DerInputStream derInputStream, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateX509Key", derInputStream, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        DerValue derValue = derInputStream.getDerValue();
        this.key = X509Key.parse(derValue, string);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateX509Key");
        }
    }

    public CertificateX509Key(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateX509Key", inputStream);
        }
        DerValue derValue = new DerValue(inputStream);
        this.key = X509Key.parse(derValue);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateX509Key");
        }
    }

    public CertificateX509Key(InputStream inputStream, String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateX509Key", inputStream, string);
        }
        if (string != null) {
            this.provider = new String(string);
        }
        DerValue derValue = new DerValue(inputStream);
        this.key = X509Key.parse(derValue, string);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateX509Key");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        if (this.key == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "toString_1", "");
            }
            return "";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString_2", this.key.toString());
        }
        return this.key.toString();
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.write(this.key.getEncoded());
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!string.equalsIgnoreCase(KEY)) {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet: CertificateX509Key.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = (PublicKey)object;
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(KEY)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get", this.key);
            }
            return this.key;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (!string.equalsIgnoreCase(KEY)) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet: CertificateX509Key.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet: CertificateX509Key.");
        }
        this.key = null;
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(KEY);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, className, "NAME");
        }
        return NAME;
    }
}

