/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.OIDMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;

public final class CertificateExtensions
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions";
    public static final String NAME = "extensions";
    private Hashtable map = new Hashtable(11);
    private boolean unsupportedCritExt = false;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.CertificateExtensions";
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public CertificateExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "CertificateExtensions");
            debug.exit(16384L, className, "CertificateExtensions");
        }
    }

    public CertificateExtensions(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "CertificateExtensions", derInputStream);
        }
        this.init(derInputStream);
        if (debug != null) {
            debug.exit(16384L, className, "CertificateExtensions");
        }
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    void decodeThis(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decodeThis", inputStream);
        }
        DerValue derValue = new DerValue(inputStream);
        this.init(derValue.getData());
        if (debug != null) {
            debug.exit(16384L, className, "decodeThis");
        }
    }

    private void init(DerInputStream derInputStream) throws IOException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "init", derInputStream);
        }
        DerValue[] derValueArray = derInputStream.getSequence(5);
        for (int i = 0; i < derValueArray.length; ++i) {
            Extension extension = new Extension(derValueArray[i]);
            this.parseExtension(extension);
        }
        if (debug != null) {
            debug.exit(8192L, className, "init");
        }
    }

    private Object copyExtension(Extension extension) {
        try {
            Class clazz;
            if (debug != null) {
                debug.entry(8192L, (Object)className, "copyExtension", extension);
            }
            if ((clazz = OIDMap.getClass(extension.getExtensionId())) == null) {
                if (debug != null) {
                    debug.exit(8192L, (Object)className, "copyExtension_1", new Extension(extension));
                }
                return new Extension(extension);
            }
            Class[] classArray = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = CertificateExtensions.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = CertificateExtensions.class$("java.lang.Object")) : class$java$lang$Object};
            Constructor constructor = clazz.getConstructor(classArray);
            byte[] byArray = extension.getExtensionValue();
            int n = byArray.length;
            Object object = Array.newInstance(Byte.TYPE, n);
            for (int i = 0; i < n; ++i) {
                Array.setByte(object, i, byArray[i]);
            }
            Object[] objectArray = new Object[]{new Boolean(extension.isCritical()), object};
            if (debug != null) {
                debug.exit(8192L, (Object)className, "copyExtension_2", (CertAttrSet)constructor.newInstance(objectArray));
            }
            return (CertAttrSet)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "copyExtension", exception);
                debug.exit(8192L, (Object)className, "copyExtension_3", null);
            }
            return null;
        }
    }

    private void parseExtension(Extension extension) throws IOException {
        try {
            Class clazz;
            if (debug != null) {
                debug.entry(8192L, (Object)className, "parseExtension", extension);
            }
            if ((clazz = OIDMap.getClass(extension.getExtensionId())) == null) {
                if (extension.isCritical()) {
                    this.unsupportedCritExt = true;
                }
                if (this.map.put(extension.getExtensionId().toString(), extension) == null) {
                    if (debug != null) {
                        debug.exit(8192L, className, "parseExtension_1");
                    }
                    return;
                }
                if (debug != null) {
                    debug.text(8192L, className, "parseExtension", "Duplicate extensions not allowed");
                }
                throw new IOException("Duplicate extensions not allowed");
            }
            Class[] classArray = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = CertificateExtensions.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Object == null ? (class$java$lang$Object = CertificateExtensions.class$("java.lang.Object")) : class$java$lang$Object};
            Constructor constructor = clazz.getConstructor(classArray);
            byte[] byArray = extension.getExtensionValue();
            int n = byArray.length;
            Object object = Array.newInstance(Byte.TYPE, n);
            for (int i = 0; i < n; ++i) {
                Array.setByte(object, i, byArray[i]);
            }
            Object[] objectArray = new Object[]{new Boolean(extension.isCritical()), object};
            CertAttrSet certAttrSet = (CertAttrSet)constructor.newInstance(objectArray);
            if (this.map.put(certAttrSet.getName(), certAttrSet) != null) {
                if (debug != null) {
                    debug.text(8192L, className, "parseExtension", "Duplicate extensions not allowed");
                }
                throw new IOException("Duplicate extensions not allowed");
            }
            if (debug != null) {
                debug.exit(8192L, className, "parseExtension_1");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            if (debug != null) {
                debug.exception(8192L, className, "parseExtension", invocationTargetException);
            }
            throw new IOException(invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "parseExtension", exception);
            }
            throw new IOException(exception.toString());
        }
    }

    public void encode(OutputStream outputStream) throws CertificateException, IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.encode(outputStream, false);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void encode(OutputStream outputStream, boolean bl) throws CertificateException, IOException {
        DerOutputStream derOutputStream;
        if (debug != null) {
            debug.entry(16384L, className, "encode", outputStream, new Boolean(bl));
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        Collection collection = this.map.values();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof CertAttrSet) {
                ((CertAttrSet)objectArray[i]).encode(derOutputStream2);
                continue;
            }
            if (objectArray[i] instanceof Extension) {
                ((Extension)objectArray[i]).encode(derOutputStream2);
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "encode", "Illegal extension object");
            }
            throw new CertificateException("Illegal extension object");
        }
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream3.write((byte)48, derOutputStream2);
        if (!bl) {
            derOutputStream = new DerOutputStream();
            derOutputStream.write(DerValue.createTag((byte)-128, true, (byte)3), derOutputStream3);
        } else {
            derOutputStream = derOutputStream3;
        }
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (!(object instanceof Extension)) {
            if (debug != null) {
                debug.entry(16384L, (Object)className, "set", "Unknown extension type.");
            }
            throw new IOException("Unknown extension type.");
        }
        this.map.put(string, object);
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        Object v;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if ((v = this.map.get(string)) == null) {
            if (debug != null) {
                debug.text(16384L, className, "get", "No extension found with name " + string);
            }
            throw new IOException("No extension found with name " + string);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get", this.copyExtension((Extension)v));
        }
        return this.copyExtension((Extension)v);
    }

    public void delete(String string) throws IOException {
        Object v;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if ((v = this.map.get(string)) == null) {
            if (debug != null) {
                debug.text(16384L, className, "delete", "No extension found with name " + string);
            }
            throw new IOException("No extension found with name " + string);
        }
        this.map.remove(string);
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        Enumeration enumeration = this.map.elements();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(11);
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            hashtable.put(extension.getExtensionId().toString(), this.copyExtension(extension));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", hashtable.elements());
        }
        return hashtable.elements();
    }

    public Set entrySet() {
        if (debug != null) {
            debug.entry(16384L, className, "entrySet");
        }
        HashSet<Object> hashSet = new HashSet<Object>(11);
        Enumeration enumeration = this.map.elements();
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            hashSet.add(this.copyExtension(extension));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "entrySet", hashSet);
        }
        return hashSet;
    }

    public Collection getAllExtensions() {
        if (debug != null) {
            debug.entry(16384L, className, "getAllExtensions");
        }
        Enumeration enumeration = this.map.elements();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(11);
        while (enumeration.hasMoreElements()) {
            Extension extension = (Extension)enumeration.nextElement();
            hashtable.put(extension.getExtensionId().toString(), this.copyExtension(extension));
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAllExtensions", hashtable.values());
        }
        return hashtable.values();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (debug != null) {
            debug.entry(16384L, className, "hasUnsupportedCriticalExtension");
            debug.exit(16384L, (Object)className, "hasUnsupportedCriticalExtension", this.unsupportedCritExt);
        }
        return this.unsupportedCritExt;
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (this == object) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(object instanceof CertificateExtensions)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        Collection collection = ((CertificateExtensions)object).getAllExtensions();
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        if (n != this.map.size()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        String string = null;
        for (int i = 0; i < n; ++i) {
            Extension extension;
            if (objectArray[i] instanceof CertAttrSet) {
                string = ((CertAttrSet)objectArray[i]).getName();
            }
            Extension extension2 = (Extension)objectArray[i];
            if (string == null) {
                string = extension2.getExtensionId().toString();
            }
            if ((extension = (Extension)this.map.get(string)) == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals_4", false);
                }
                return false;
            }
            if (extension.equals(extension2)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_5", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_6", true);
        }
        return true;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
            debug.exit(16384L, (Object)className, "hashCode", this.map.hashCode());
        }
        return this.map.hashCode();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", this.map.toString());
        }
        return this.map.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

