/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Enumeration;

public final class BasicConstraintsExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.BasicConstraints";
    public static final String NAME = "BasicConstraints";
    public static final String IS_CA = "is_ca";
    public static final String PATH_LEN = "path_len";
    private boolean ca = false;
    private int pathLen = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.BasicConstraintsExtension";

    private void encodeThis() throws IOException {
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (!this.ca && this.pathLen < 0) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis");
            }
            return;
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.ca) {
            derOutputStream2.putBoolean(this.ca);
        }
        if (this.pathLen >= 0) {
            derOutputStream2.putInteger(BigInteger.valueOf(this.pathLen));
        }
        derOutputStream.write((byte)48, derOutputStream2);
        this.extensionValue = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis");
        }
    }

    public BasicConstraintsExtension(boolean bl, int n) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "BasicConstraintsExtension", new Boolean(bl), new Integer(n));
        }
        this.ca = bl;
        this.pathLen = n;
        this.extensionId = PKIXExtensions.BasicConstraints_Id;
        this.critical = bl;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "BasicConstraintsExtension");
        }
    }

    public BasicConstraintsExtension(Boolean bl, Object object) throws IOException {
        DerValue derValue;
        if (debug != null) {
            debug.entry(16384L, className, "BasicConstraintsExtension", bl, object);
        }
        this.extensionId = PKIXExtensions.BasicConstraints_Id;
        this.critical = bl;
        if (object instanceof byte[]) {
            int n = Array.getLength(object);
            byte[] byArray = new byte[n];
            System.arraycopy(object, 0, byArray, 0, n);
            this.extensionValue = byArray;
            DerValue derValue2 = new DerValue(byArray);
            if (derValue2.getTag() != 48) {
                if (debug != null) {
                    debug.text(16384L, className, "BasicConstraintsExtension", "Invalid encoding of BasicConstraints");
                }
                throw new IOException("Invalid encoding of BasicConstraints");
            }
            if (derValue2.getData() == null) {
                return;
            }
            derValue = derValue2.getData().getDerValue();
            if (derValue.getTag() != 1) {
                return;
            }
            this.ca = derValue.getBoolean();
            if (derValue2.getData().available() == 0) {
                this.pathLen = Integer.MAX_VALUE;
                if (debug != null) {
                    debug.exit(16384L, className, "BasicConstraintsExtension_1");
                }
                return;
            }
            derValue = derValue2.getData().getDerValue();
            if (derValue.getTag() != 2) {
                if (debug != null) {
                    debug.text(16384L, className, "BasicConstraintsExtension", "Invalid encoding of BasicConstraints");
                }
                throw new IOException("Invalid encoding of BasicConstraints");
            }
        } else {
            if (debug != null) {
                debug.text(16384L, className, "BasicConstraintsExtension", "Invalid argument type");
            }
            throw new IOException("Invalid argument type");
        }
        this.pathLen = derValue.getInteger().intValue();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "BasicConstraintsExtension_2", "Invalid argument type");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = super.toString() + "BasicConstraints:[\n";
        string = string + (this.ca ? "CA:true" : "CA:false") + "\n";
        string = this.pathLen >= 0 ? string + "PathLen:" + this.pathLen + "\n" : string + "PathLen: undefined\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string + "]\n");
        }
        return string + "]\n";
    }

    public void decode(InputStream inputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", inputStream);
            debug.exit(16384L, (Object)className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.BasicConstraints_Id;
            this.critical = this.ca;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void set(String string, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", string, object);
        }
        if (string.equalsIgnoreCase(IS_CA)) {
            if (!(object instanceof Boolean)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Boolean.");
                }
                throw new IOException("Attribute value should be of type Boolean.");
            }
            this.ca = (Boolean)object;
        } else if (string.equalsIgnoreCase(PATH_LEN)) {
            if (!(object instanceof Integer)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type Integer.");
                }
                throw new IOException("Attribute value should be of type Integer.");
            }
            this.pathLen = (Integer)object;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:BasicConstraints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    public Object get(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", string);
        }
        if (string.equalsIgnoreCase(IS_CA)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", new Boolean(this.ca));
            }
            return new Boolean(this.ca);
        }
        if (string.equalsIgnoreCase(PATH_LEN)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_2", new Integer(this.pathLen));
            }
            return new Integer(this.pathLen);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "get_3", "Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
    }

    public void delete(String string) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", string);
        }
        if (string.equalsIgnoreCase(IS_CA)) {
            this.ca = false;
        } else if (string.equalsIgnoreCase(PATH_LEN)) {
            this.pathLen = -1;
        } else {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "delete", "Attribute name not recognized by CertAttrSet:BasicConstraints.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:BasicConstraints.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    public Enumeration getElements() {
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(IS_CA);
        attributeNameEnumeration.addElement(PATH_LEN);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", attributeNameEnumeration.elements());
        }
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

