/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.util;

import com.ibm.security.util.BitArray;
import com.ibm.security.util.DerIndefLenConverter;
import com.ibm.security.util.DerInputBuffer;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.util.UTFUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public final class DerInputStream {
    DerInputBuffer buffer;

    public DerInputStream(byte[] byArray) {
        this.init(byArray, 0, byArray.length);
    }

    public DerInputStream(byte[] byArray, int n, int n2) {
        this.init(byArray, n, n2);
    }

    private void init(byte[] byArray, int n, int n2) {
        if (DerIndefLenConverter.isIndefinite(byArray[n + 1])) {
            try {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, n, byArray2, 0, n2);
                DerIndefLenConverter derIndefLenConverter = new DerIndefLenConverter();
                byte[] byArray3 = DerIndefLenConverter.convertIndefToDef(byArray2);
                this.buffer = new DerInputBuffer(byArray3);
            }
            catch (IOException iOException) {}
        } else {
            this.buffer = new DerInputBuffer(byArray, n, n2);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    DerInputStream(DerInputBuffer derInputBuffer) {
        this.buffer = derInputBuffer;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream subStream(int n, boolean bl) throws IOException {
        DerInputBuffer derInputBuffer = this.buffer.dup();
        derInputBuffer.truncate(n);
        if (bl) {
            this.buffer.skip(n);
        }
        return new DerInputStream(derInputBuffer);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public BigInteger getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer));
    }

    public BigInteger getBigInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer));
    }

    public int getSignedInt() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getSigned(DerInputStream.getLength(this.buffer));
    }

    public BigInteger getEnumerated() throws IOException {
        if (this.buffer.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.buffer.getBigInteger(DerInputStream.getLength(this.buffer));
    }

    public byte[] getBitString() throws IOException {
        byte[] byArray;
        byte by = (byte)this.buffer.read();
        if (by != 3 && by != 35) {
            throw new IOException("DER input not an bit string");
        }
        int n = DerInputStream.getLength(this.buffer);
        int n2 = this.buffer.read();
        if (n2 < 0 || n2 > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        if (this.buffer.read(byArray = new byte[--n]) != n) {
            throw new IOException("short read of DER bit string");
        }
        if (n2 != 0) {
            int n3 = n - 1;
            byArray[n3] = (byte)(byArray[n3] & 255 << n2);
        }
        return byArray;
    }

    public BitArray getUnalignedBitString() throws IOException {
        byte by = (byte)this.buffer.read();
        if (by != 3 && by != 35) {
            throw new IOException("DER input not a bit string");
        }
        int n = DerInputStream.getLength(this.buffer);
        int n2 = --n * 8 - this.buffer.read();
        byte[] byArray = new byte[n];
        if (this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(n2, byArray);
    }

    public byte[] getOctetString() throws IOException {
        byte by = (byte)this.buffer.read();
        if (by != 4 && by != 36) {
            throw new IOException("DER input not an octet string");
        }
        int n = DerInputStream.getLength(this.buffer);
        if (n == 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        n2 = this.buffer.read(byArray);
        if (n2 != n) {
            throw new IOException("short read of DER octet string");
        }
        return byArray;
    }

    public byte[] getBMPString() throws IOException {
        byte by = (byte)this.buffer.read();
        if (by != 30 && by != 62) {
            throw new IOException("DER input not a BMP string; invalid tag");
        }
        int n = DerInputStream.getLength(this.buffer);
        if (n % 2 != 0) {
            throw new IOException("DER input not a BMP string; invalid length");
        }
        byte[] byArray = new byte[n];
        if (this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER BMPString");
        }
        return byArray;
    }

    public void getBytes(byte[] byArray) throws IOException {
        if (byArray.length != 0 && this.buffer.read(byArray) != byArray.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DerValue[] getSequence(int n) throws IOException {
        if (this.buffer.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n) throws IOException {
        int n2 = this.buffer.read();
        if (n2 != 49) {
            throw new IOException("Set tag error.  Found tag " + n2);
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n, boolean bl) throws IOException {
        int n2 = this.buffer.read();
        if (!bl && n2 != 49) {
            throw new IOException("Set tag error.  Found tag " + n2);
        }
        return this.readVector(n);
    }

    protected DerValue[] readVector(int n) throws IOException {
        int n2 = DerInputStream.getLength(this.buffer);
        if (n2 == 0) {
            return new DerValue[0];
        }
        DerInputStream derInputStream = this.buffer.available() == n2 ? this : this.subStream(n2, true);
        Vector<DerValue> vector = new Vector<DerValue>(n, 5);
        do {
            DerValue derValue = new DerValue(derInputStream.buffer);
            vector.addElement(derValue);
        } while (derInputStream.available() > 0);
        if (derInputStream.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int n3 = vector.size();
        DerValue[] derValueArray = new DerValue[n3];
        for (int i = 0; i < n3; ++i) {
            derValueArray[i] = (DerValue)vector.elementAt(i);
        }
        return derValueArray;
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    private String simpleGetString(int n) throws IOException {
        int n2 = DerInputStream.getLength(this.buffer);
        byte[] byArray = new byte[n2];
        if (n2 != 0 && this.buffer.read(byArray) != n2) {
            throw new IOException("short read of DER Printable string");
        }
        String string = null;
        try {
            string = new String(byArray, "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray);
        }
        return string;
    }

    public String getPrintableString() throws IOException {
        byte by = (byte)this.buffer.read();
        if (by != 19 && by != 51) {
            throw new IOException("DER input not a Printable string");
        }
        return this.simpleGetString(by);
    }

    public String getT61String() throws IOException {
        byte by = (byte)this.buffer.read();
        if (by != 20 && by != 52) {
            throw new IOException("DER input not a T61 string");
        }
        return this.simpleGetString(by);
    }

    public String getIA5String() throws IOException {
        byte by = (byte)this.buffer.read();
        if (by != 22 && by != 54) {
            throw new IOException("DER input not an IA5 string");
        }
        return this.simpleGetString(by);
    }

    public String getUTF8String() throws IOException {
        byte by = (byte)this.buffer.read();
        if (by != 12 && by != 44) {
            throw new IOException("DER input not a UTF8 string");
        }
        int n = DerInputStream.getLength(this.buffer);
        byte[] byArray = new byte[n];
        if (n != 0 && this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER UTF8 string");
        }
        StringBuffer stringBuffer = UTFUtils.fromUTF(byArray);
        return new String(stringBuffer);
    }

    public String getUniversalString() throws IOException {
        byte by = (byte)this.buffer.read();
        if (by != 28 && by != 60) {
            throw new IOException("DER input not a Universal string");
        }
        int n = DerInputStream.getLength(this.buffer);
        byte[] byArray = new byte[n];
        if (n != 0 && this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER Universal string");
        }
        StringBuffer stringBuffer = UTFUtils.fromUniv(byArray);
        return new String(stringBuffer);
    }

    public Date getUTCTime() throws IOException {
        int n;
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        if (this.buffer.available() < 11) {
            throw new IOException("DER input, UTCtime short input");
        }
        int n2 = DerInputStream.getLength(this.buffer);
        if (n2 < 11 || n2 > 17) {
            throw new IOException("DER getUTCTime length error");
        }
        int n3 = 10 * Character.digit((char)this.buffer.read(), 10);
        n3 = (n3 += Character.digit((char)this.buffer.read(), 10)) < 50 ? (n3 += 2000) : (n3 += 1900);
        int n4 = 10 * Character.digit((char)this.buffer.read(), 10);
        n4 += Character.digit((char)this.buffer.read(), 10);
        --n4;
        int n5 = 10 * Character.digit((char)this.buffer.read(), 10);
        n5 += Character.digit((char)this.buffer.read(), 10);
        int n6 = 10 * Character.digit((char)this.buffer.read(), 10);
        n6 += Character.digit((char)this.buffer.read(), 10);
        int n7 = 10 * Character.digit((char)this.buffer.read(), 10);
        n7 += Character.digit((char)this.buffer.read(), 10);
        if ((n2 -= 10) == 3 || n2 == 7) {
            n = 10 * Character.digit((char)this.buffer.read(), 10);
            n += Character.digit((char)this.buffer.read(), 10);
            n2 -= 2;
        } else {
            n = 0;
        }
        if (n4 < 0 || n5 <= 0 || n4 > 11 || n5 > 31 || n6 >= 24 || n7 >= 60 || n >= 60) {
            throw new IOException("Parse UTC time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(n3, n4, n5, n6, n7, n);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l = date.getTime();
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Parse UTC time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 45: {
                int n8 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n9 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n8 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n9 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, +hhmm");
                }
                l += (long)((n8 * 60 + n9) * 60 * 1000);
                break;
            }
            case 43: {
                int n10 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n11 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n10 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n11 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, -hhmm");
                }
                l -= (long)((n10 * 60 + n11) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse UTCtime, garbage offset");
            }
        }
        date.setTime(l);
        return date;
    }

    public Date getGeneralizedTime() throws IOException {
        int n;
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        if (this.buffer.available() < 13) {
            throw new IOException("DER input, GeneralizedTime short input");
        }
        int n2 = DerInputStream.getLength(this.buffer);
        int n3 = 1000 * Character.digit((char)this.buffer.read(), 10);
        n3 += 100 * Character.digit((char)this.buffer.read(), 10);
        n3 += 10 * Character.digit((char)this.buffer.read(), 10);
        n3 += Character.digit((char)this.buffer.read(), 10);
        int n4 = 10 * Character.digit((char)this.buffer.read(), 10);
        n4 += Character.digit((char)this.buffer.read(), 10);
        --n4;
        int n5 = 10 * Character.digit((char)this.buffer.read(), 10);
        n5 += Character.digit((char)this.buffer.read(), 10);
        int n6 = 10 * Character.digit((char)this.buffer.read(), 10);
        n6 += Character.digit((char)this.buffer.read(), 10);
        int n7 = 10 * Character.digit((char)this.buffer.read(), 10);
        n7 += Character.digit((char)this.buffer.read(), 10);
        if ((n2 -= 12) == 3 || n2 == 7) {
            n = 10 * Character.digit((char)this.buffer.read(), 10);
            n += Character.digit((char)this.buffer.read(), 10);
            n2 -= 2;
        } else {
            n = 0;
        }
        if (n4 < 0 || n5 <= 0 || n4 > 11 || n5 > 31 || n6 >= 24 || n7 >= 60 || n >= 60) {
            throw new IOException("Parse Generalized time, invalid format");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(n3, n4, n5, n6, n7, n);
        calendar.set(0, 1);
        Date date = calendar.getTime();
        long l = date.getTime();
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Parse Generalized time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 45: {
                int n8 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n9 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n8 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n9 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, +hhmm");
                }
                l += (long)((n8 * 60 + n9) * 60 * 1000);
                break;
            }
            case 43: {
                int n10 = 10 * Character.digit((char)this.buffer.read(), 10);
                int n11 = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((n10 += Character.digit((char)this.buffer.read(), 10)) >= 24 || (n11 += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, -hhmm");
                }
                l -= (long)((n10 * 60 + n11) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse GeneralizedTime, garbage offset");
            }
        }
        date.setTime(l);
        return date;
    }

    public String getGeneralString() throws IOException {
        byte by = (byte)this.buffer.read();
        if (by != 27) {
            throw new IOException("DER input not a General string");
        }
        return this.simpleGetString(by);
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(InputStream inputStream) throws IOException {
        return DerInputStream.getLength(inputStream.read(), inputStream);
    }

    static int getLength(int n, InputStream inputStream) throws IOException {
        int n2;
        int n3 = n;
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            if ((n3 &= 0x7F) == 0) {
                return -1;
            }
            if (n3 < 0 || n3 > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + n3 + ", " + (n3 < 0 ? "incorrect DER encoding." : "too big."));
            }
            n2 = 0;
            while (n3 > 0) {
                n2 <<= 8;
                n2 += 0xFF & inputStream.read();
                --n3;
            }
        }
        return n2;
    }

    public void mark(int n) {
        this.buffer.mark(n);
    }

    public void reset() {
        this.buffer.reset();
    }

    public int available() {
        return this.buffer.available();
    }
}

