/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class UnresolvedAttribute
extends PKCSDerObject
implements DerEncoder,
Cloneable {
    private ObjectIdentifier attributeId;
    private byte[] attributeValue;
    private String provider = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.UnresolvedAttribute";

    public UnresolvedAttribute() {
        if (debug != null) {
            debug.entry(16384L, className, "UnresolvedAttribute");
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UnresolvedAttribute", string);
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "UnresolvedAttribute", (Object)byArray);
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "UnresolvedAttribute", byArray, string);
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(ObjectIdentifier objectIdentifier, Object object) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "UnresolvedAttribute", objectIdentifier, object);
        }
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "UnresolvedAttribute", "Non-standard Attribute value must be a byte array");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be a byte array");
        }
        DerValue derValue = new DerValue((byte[])object);
        if (derValue.getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "UnresolvedAttribute", "Non-standard Attribute value must be DER-encoding of a SET OF");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be DER-encoding of a SET OF");
        }
        this.attributeId = objectIdentifier;
        this.attributeValue = (byte[])object;
        if (debug != null) {
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(ObjectIdentifier objectIdentifier, Object object, String string) throws IOException {
        Object[] objectArray;
        if (debug != null) {
            objectArray = new Object[]{objectIdentifier, object, string};
            debug.entry(16384L, className, "UnresolvedAttribute");
        }
        if (!(object instanceof byte[])) {
            if (debug != null) {
                debug.text(16384L, className, "UnresolvedAttribute", "Non-standard Attribute value must be a byte array");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be a byte array");
        }
        objectArray = new DerValue((byte[])object);
        if (objectArray.getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "UnresolvedAttribute", "Non-standard Attribute value must be DER-encoding of a SET OF");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be DER-encoding of a SET OF");
        }
        this.attributeId = objectIdentifier;
        this.attributeValue = (byte[])object;
        if (debug != null) {
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "UnresolvedAttribute", string, new Boolean(bl));
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public UnresolvedAttribute(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "UnresolvedAttribute", objectArray);
            debug.exit(16384L, className, "UnresolvedAttribute");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
                debug.exit(16384L, (Object)className, "clone_1", new UnresolvedAttribute(this.attributeId, this.attributeValue, ((PKCSDerObject)this).provider));
            }
            return new UnresolvedAttribute(this.attributeId, this.attributeValue, ((PKCSDerObject)this).provider);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof UnresolvedAttribute) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", this.equals((UnresolvedAttribute)object));
            }
            return this.equals((UnresolvedAttribute)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_2", false);
        }
        return false;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "encode");
        }
        this.derEncode(outputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", outputStream);
        }
        if (this.attributeValue == null) {
            if (debug != null) {
                debug.text(16384L, className, "derEncode", "Attribute value is null");
            }
            throw new IOException("Attribute value is null");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.attributeId);
        derOutputStream.write(this.attributeValue);
        derOutputStream2.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream2.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", this.attributeId);
        }
        return this.attributeId;
    }

    public Object getValue() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
        }
        UnresolvedAttribute unresolvedAttribute = new UnresolvedAttribute(this.attributeId, this.attributeValue, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue", unresolvedAttribute.attributeValue);
        }
        return unresolvedAttribute.attributeValue;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String string = "Object Identifier: ";
        string = string + this.attributeId.toString();
        string = string + "\r\n";
        string = string + "Value:\r\n";
        string = string + hexDumpEncoder.encodeBuffer(this.attributeValue);
        string = string + "\r\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (derValue.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PKCS Attribute encoding error");
            }
            throw new IOException("PKCS Attribute encoding error");
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derInputStream.available() != 0) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Excess data parsing PKCS Attribute");
            }
            throw new IOException("Excess data parsing PKCS Attribute");
        }
        if (derValueArray.length != 2) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "PKCS Attribute doesn't have two components");
            }
            throw new IOException("PKCS Attribute doesn't have two components");
        }
        this.attributeId = derValueArray[0].getOID();
        if (derValueArray[1].getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Non-standard Attribute value must be DER-encoding of a SET OF");
            }
            throw new IllegalArgumentException("Non-standard Attribute value must be DER-encoding of a SET OF");
        }
        this.attributeValue = derValueArray[1].toByteArray();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(UnresolvedAttribute unresolvedAttribute) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", unresolvedAttribute);
        }
        if (unresolvedAttribute == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_1", true);
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            unresolvedAttribute.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals_2", false);
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals_3", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals_4", false);
        }
        return true;
    }
}

