/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcsutil;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs9.PKCS9;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.pkcsutil.UnresolvedAttribute;
import com.ibm.security.util.DerEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public final class PKCSAttributes
extends PKCSDerObject
implements DerEncoder,
Cloneable {
    private Hashtable map;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcsutil.PKCSAttributes";
    private DerValue orig_derValue;

    public PKCSAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttributes");
            debug.exit(16384L, className, "PKCSAttributes");
        }
        this.map = new Hashtable(3);
    }

    public PKCSAttributes(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttributes", string);
            debug.exit(16384L, className, "PKCSAttributes");
        }
        this.map = new Hashtable(3);
    }

    public PKCSAttributes(DerInputStream derInputStream) throws IOException {
        this(derInputStream, null);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttributes", derInputStream);
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(DerInputStream derInputStream, String string) throws IOException {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttributes", derInputStream, string);
        }
        this.map = new Hashtable(3);
        byte[] byArray = derInputStream.toByteArray();
        DerValue[] derValueArray = derInputStream.peekByte() == 49 ? derInputStream.getSet(3) : derInputStream.getSet(3, true);
        if (derValueArray == null) {
            if (debug != null) {
                debug.text(16384L, className, "PKCSAttributes", "Illegal encoding of attributes");
            }
            throw new IOException("Illegal encoding of attributes");
        }
        for (int i = 0; i < derValueArray.length; ++i) {
            PKCSAttribute pKCSAttribute = new PKCSAttribute(derValueArray[i].toByteArray(), this.provider);
            this.map.put(pKCSAttribute.getAttributeId().toString(), pKCSAttribute);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
        this.orig_derValue = new DerValue(byArray);
    }

    public PKCSAttributes(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttributes", (Object)byArray);
        }
        if (this.map == null) {
            this.map = new Hashtable(3);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttributes", byArray, string);
        }
        if (this.map == null) {
            this.map = new Hashtable(3);
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(PKCSAttribute[] pKCSAttributeArray) {
        this.map = new Hashtable(3);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCSAttributes", pKCSAttributeArray);
        }
        if (pKCSAttributeArray != null && pKCSAttributeArray.length > 0) {
            for (int i = 0; i < pKCSAttributeArray.length; ++i) {
                this.map.put(pKCSAttributeArray[i].getAttributeId().toString(), pKCSAttributeArray[i]);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(PKCSAttribute[] pKCSAttributeArray, String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, className, "PKCSAttributes", pKCSAttributeArray, string);
        }
        this.map = new Hashtable(3);
        if (pKCSAttributeArray != null && pKCSAttributeArray.length > 0) {
            for (int i = 0; i < pKCSAttributeArray.length; ++i) {
                this.map.put(pKCSAttributeArray[i].getAttributeId().toString(), pKCSAttributeArray[i]);
            }
        }
        if (debug != null) {
            debug.exit(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl)};
            debug.entry(16384L, (Object)className, "PKCSAttributes", objectArray);
            debug.entry(16384L, className, "PKCSAttributes");
        }
    }

    public PKCSAttributes(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "PKCSAttributes", objectArray);
            debug.entry(16384L, className, "PKCSAttributes");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            PKCSAttributes pKCSAttributes = new PKCSAttributes(this.provider);
            Enumeration enumeration = this.getElements();
            while (enumeration.hasMoreElements()) {
                PKCSAttribute pKCSAttribute = (PKCSAttribute)enumeration.nextElement();
                pKCSAttributes = pKCSAttributes.addAttribute(pKCSAttribute);
            }
            if (this.orig_derValue != null) {
                pKCSAttributes.orig_derValue = new DerValue(this.orig_derValue.toByteArray());
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", pKCSAttributes);
            }
            return pKCSAttributes;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        this.derEncode(outputStream);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public byte[] generateDerEncoding() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, className, "generateDerEncoding");
        }
        Object[] objectArray = this.map.values().toArray();
        derOutputStream.putOrderedSetOf((byte)49, PKCSAttributes.castToDerEncoder(objectArray));
        byte[] byArray = derOutputStream.toByteArray();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "generateDerEncoding", byArray);
        }
        return byArray;
    }

    static DerEncoder[] castToDerEncoder(Object[] objectArray) {
        DerEncoder[] derEncoderArray = new DerEncoder[objectArray.length];
        if (debug != null) {
            debug.entry(49152L, (Object)className, "castToDerEncoder", objectArray);
        }
        for (int i = 0; i < derEncoderArray.length; ++i) {
            derEncoderArray[i] = (DerEncoder)objectArray[i];
        }
        if (debug != null) {
            debug.exit(49152L, (Object)className, "castToDerEncoder", derEncoderArray);
        }
        return derEncoderArray;
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "derEncode", outputStream);
        }
        PKCSAttribute[] pKCSAttributeArray = this.getAttributes();
        DerOutputStream derOutputStream = new DerOutputStream();
        DerEncoder[] derEncoderArray = new DerOutputStream[pKCSAttributeArray.length];
        for (int i = 0; i < pKCSAttributeArray.length; ++i) {
            derEncoderArray[i] = new DerOutputStream();
            pKCSAttributeArray[i].encode((OutputStream)((Object)derEncoderArray[i]));
        }
        derOutputStream.putOrderedSetOf((byte)49, derEncoderArray);
        outputStream.write(derOutputStream.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "derEncode");
        }
    }

    public PKCSAttributes addAttribute(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttribute", pKCSAttribute);
        }
        if (pKCSAttribute == null || pKCSAttribute.getAttributeId() == null || pKCSAttribute.getAttributeId().toString().length() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addAttribute", "Invalid input attribute");
            }
            throw new IllegalArgumentException("Invalid input attribute");
        }
        PKCSAttributes pKCSAttributes = (PKCSAttributes)this.clone();
        pKCSAttributes.map.put(pKCSAttribute.getAttributeId().toString(), pKCSAttribute);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttribute", pKCSAttributes);
        }
        return pKCSAttributes;
    }

    public PKCSAttributes addAttributes(PKCSAttributes pKCSAttributes) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "addAttributes", pKCSAttributes);
        }
        if (pKCSAttributes == null || pKCSAttributes.size() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addAttributes", "Invalid input attribute.");
            }
            throw new IllegalArgumentException("Invalid input attribute.");
        }
        PKCSAttributes pKCSAttributes2 = (PKCSAttributes)this.clone();
        Enumeration enumeration = pKCSAttributes2.getElements();
        while (enumeration.hasMoreElements()) {
            PKCSAttribute pKCSAttribute = (PKCSAttribute)enumeration.nextElement();
            pKCSAttributes2 = pKCSAttributes2.addAttribute(pKCSAttribute);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "addAttributes", pKCSAttributes2);
        }
        return pKCSAttributes2;
    }

    public Object getAttribute(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAttribute", string);
        }
        PKCSAttribute pKCSAttribute = (PKCSAttribute)this.map.get(string);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttribute", pKCSAttribute.clone());
        }
        return pKCSAttribute.clone();
    }

    public Object getAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAttribute", objectIdentifier);
        }
        if (objectIdentifier == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAttribute_1", null);
            }
            return null;
        }
        PKCSAttribute pKCSAttribute = (PKCSAttribute)this.map.get(objectIdentifier.toString());
        if (pKCSAttribute == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getAttribute_2", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttribute_3", pKCSAttribute.clone());
        }
        return pKCSAttribute.clone();
    }

    public PKCSAttributes deleteAttribute(String string) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteAttribute", string);
        }
        PKCSAttributes pKCSAttributes = (PKCSAttributes)this.clone();
        pKCSAttributes.map.remove(string);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteAttribute", pKCSAttributes);
        }
        return pKCSAttributes;
    }

    public PKCSAttributes deleteAttribute(ObjectIdentifier objectIdentifier) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteAttribute", objectIdentifier);
        }
        if (objectIdentifier == null) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "deleteAttribute_1", this);
            }
            return this;
        }
        PKCSAttributes pKCSAttributes = (PKCSAttributes)this.clone();
        pKCSAttributes.map.remove(objectIdentifier.toString());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteAttribute_2", pKCSAttributes);
        }
        return pKCSAttributes;
    }

    public PKCSAttributes deleteAttribute(PKCSAttribute pKCSAttribute) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "deleteAttribute", pKCSAttribute);
        }
        if (pKCSAttribute == null || pKCSAttribute.getAttributeId() == null || pKCSAttribute.getAttributeId().toString().length() == 0) {
            if (debug != null) {
                debug.text(16384L, className, "deleteAttribute", "Invalid input attribute");
            }
            throw new IllegalArgumentException("Invalid input attribute");
        }
        PKCSAttributes pKCSAttributes = (PKCSAttributes)this.clone();
        pKCSAttributes = pKCSAttributes.deleteAttribute(pKCSAttribute.getAttributeId().toString());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "deleteAttribute", pKCSAttributes);
        }
        return pKCSAttributes;
    }

    public PKCSAttribute[] getAttributes() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributes");
        }
        PKCSAttribute[] pKCSAttributeArray = new PKCSAttribute[this.size()];
        Enumeration enumeration = this.getElements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            pKCSAttributeArray[n] = (PKCSAttribute)enumeration.nextElement();
            ++n;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getAttributes", pKCSAttributeArray);
        }
        return pKCSAttributeArray;
    }

    public int size() {
        if (debug != null) {
            debug.entry(16384L, className, "size");
            debug.exit(16384L, (Object)className, "size", this.map.size());
        }
        return this.map.size();
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (this == object) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_1", true);
            }
            return true;
        }
        if (!(object instanceof PKCSAttributes)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_2", false);
            }
            return false;
        }
        PKCSAttribute[] pKCSAttributeArray = ((PKCSAttributes)object).getAttributes();
        int n = pKCSAttributeArray.length;
        if (n != this.map.size()) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_3", false);
            }
            return false;
        }
        String string = null;
        for (int i = 0; i < n; ++i) {
            PKCSAttribute pKCSAttribute = pKCSAttributeArray[i];
            string = pKCSAttribute.getAttributeId().toString();
            if (string == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals_4", false);
                }
                return false;
            }
            PKCSAttribute pKCSAttribute2 = (PKCSAttribute)this.map.get(string);
            if (pKCSAttribute2 == null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "equals_5", false);
                }
                return false;
            }
            if (pKCSAttribute2.equals((Object)pKCSAttribute)) continue;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals_6", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals_7", true);
        }
        return true;
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(16384L, className, "hashCode");
            debug.exit(16384L, (Object)className, "hashCode", this.map.hashCode());
        }
        return this.map.hashCode();
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = new String();
        int n = 0;
        string = string + "PKCSAttributes.length = " + this.map.size() + "\r\n";
        Enumeration enumeration = this.getElements();
        while (enumeration.hasMoreElements()) {
            String string2;
            block7: {
                Object object;
                PKCSAttribute pKCSAttribute = (PKCSAttribute)enumeration.nextElement();
                ObjectIdentifier objectIdentifier = pKCSAttribute.getAttributeId();
                String string3 = PKCS9.getName(objectIdentifier);
                String string4 = null;
                string4 = string3 == null ? objectIdentifier.toString() : string3;
                try {
                    object = pKCSAttribute.getAttributeValue();
                }
                catch (IOException iOException) {
                    object = null;
                }
                string = string + "\t[" + n + "]:\t" + string4 + "\t" + object + "\r\n";
                string2 = "\r\n";
                try {
                    DerOutputStream derOutputStream = new DerOutputStream();
                    pKCSAttribute.encode(derOutputStream);
                    string2 = hexDumpEncoder.encodeBuffer(derOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    if (debug == null) break block7;
                    debug.exception(16384L, className, "toString", iOException);
                }
            }
            string = string + string2;
            ++n;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", string);
        }
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        if (this.map == null) {
            this.map = new Hashtable(3);
        }
        DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
        DerValue[] derValueArray = derInputStream.getSet(1);
        for (int i = derValueArray.length - 1; i >= 0; --i) {
            PKCSAttribute pKCSAttribute;
            try {
                PKCS9DerObject pKCS9DerObject = PKCS9.getPKCS9Attribute(derValueArray[i].toByteArray());
                pKCSAttribute = new PKCSAttribute(pKCS9DerObject, this.provider);
            }
            catch (IOException iOException) {
                if (debug != null) {
                    debug.exception(16384L, className, "decode", iOException);
                }
                DerOutputStream derOutputStream = new DerOutputStream();
                derValueArray[i].encode(derOutputStream);
                UnresolvedAttribute unresolvedAttribute = new UnresolvedAttribute(derOutputStream.toByteArray(), this.provider);
                pKCSAttribute = new PKCSAttribute(unresolvedAttribute, this.provider);
            }
            this.map.put(pKCSAttribute.getAttributeId().toString(), pKCSAttribute);
        }
        this.orig_derValue = derValue;
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private Enumeration getElements() {
        if (debug != null) {
            debug.entry(8192L, className, "getElements");
            debug.exit(8192L, (Object)className, "getElements", this.map.elements());
        }
        return this.map.elements();
    }

    public byte[] getOriginalEncoded() throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "getDerEncoding");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.orig_derValue != null) {
            DerInputStream derInputStream = this.orig_derValue.getData();
            derOutputStream.write((byte)49, derInputStream.toByteArray());
            if (debug != null) {
                debug.exit(16384L, className, "getDerEncoding");
            }
            return derOutputStream.toByteArray();
        }
        if (debug != null) {
            debug.exit(16384L, className, "getDerEncoding");
        }
        return null;
    }
}

