/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSDerObject;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;

public abstract class PKCS9DerObject
extends PKCSDerObject
implements Cloneable {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.PKCS9DerObject";

    protected PKCS9DerObject() {
        if (debug != null) {
            debug.entry(16384L, className, "PKCS9DerObject");
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    protected PKCS9DerObject(String string) {
        super(string);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS9DerObject", string);
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public PKCS9DerObject(byte[] byArray) throws IOException {
        this();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PKCS9DerObject", (Object)byArray);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public PKCS9DerObject(byte[] byArray, String string) throws IOException {
        this(string);
        if (debug != null) {
            debug.entry(16384L, className, "PKCS9DerObject", byArray, string);
        }
        this.decode(byArray);
        if (debug != null) {
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public PKCS9DerObject(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "PKCS9DerObject", string, new Boolean(bl));
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public PKCS9DerObject(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "PKCS9DerObject", objectArray);
            debug.exit(16384L, className, "PKCS9DerObject");
        }
    }

    public ObjectIdentifier getOID() {
        if (debug != null) {
            debug.entry(16384L, className, "getOID");
            debug.exit(16384L, (Object)className, "getOID", this.getObjectIdentifier());
        }
        return this.getObjectIdentifier();
    }

    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", this.getAttributeName());
        }
        return this.getAttributeName();
    }

    public PKCSAttribute getPKCSAttribute() throws IOException {
        PKCSAttribute pKCSAttribute = new PKCSAttribute(this.getObjectIdentifier(), this.getValue(), this.provider);
        if (debug != null) {
            debug.entry(16384L, className, "getPKCSAttribute");
            debug.exit(16384L, (Object)className, "getPKCSAttribute", pKCSAttribute);
        }
        return pKCSAttribute;
    }

    protected void decode(DerValue derValue) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        String string = this.getAttributeName();
        if (derValue.getTag() != 48 && derValue.getTag() != 49) {
            if (debug != null) {
                debug.text(16384L, className, "decode", "Unknown tag " + derValue.getTag() + " for decode.");
            }
            throw new IOException("Unknown tag " + derValue.getTag() + " for decode.");
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            if (derInputStream.available() != 0) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "Excess data parsing " + string + ".");
                }
                throw new IOException("Excess data parsing " + string + ".");
            }
            if (derValueArray2.length != 2) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", string + " does not have two components.");
                }
                throw new IOException(string + " does not have two components.");
            }
            ObjectIdentifier objectIdentifier = derValueArray2[0].getOID();
            if (!objectIdentifier.equals(this.getObjectIdentifier())) {
                if (debug != null) {
                    debug.text(16384L, className, "decode", "Invalid OID for " + string + ": " + objectIdentifier);
                }
                throw new IOException("Invalid OID for " + string + ": " + objectIdentifier);
            }
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        if (this.isSingleValued() && derValueArray.length > 1) {
            if (debug != null) {
                debug.text(16384L, className, "decode", string + " must have a single value.  Instead it has " + derValueArray.length + ".");
            }
            throw new IOException(string + " must have a single value.  Instead it has " + derValueArray.length + ".");
        }
        for (int i = 0; i < derValueArray.length; ++i) {
            byte by = derValueArray[i].getTag();
            if (this.isTagValid(by)) continue;
            if (debug != null) {
                debug.text(16384L, className, "decode", string + " has an invalid tag " + by + " at element " + i + ".");
            }
            throw new IOException(string + " has an invalid tag " + by + " at element " + i + ".");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    public abstract boolean isTagValid(byte var1);

    public abstract boolean isSingleValued();

    public abstract String getAttributeName();

    public abstract Object getValue();
}

