/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.misc.HexDumpEncoder;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class LocalKeyId
extends PKCS9DerObject
implements Cloneable {
    private byte[] keyId;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.LocalKeyId";

    public LocalKeyId(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "LocalKeyId", (Object)byArray);
            debug.exit(16384L, className, "LocalKeyId");
        }
    }

    public LocalKeyId(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "LocalKeyId", byArray, string);
            debug.exit(16384L, className, "LocalKeyId");
        }
    }

    public LocalKeyId(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "LocalKeyId", string, new Boolean(bl));
            debug.exit(16384L, className, "LocalKeyId");
        }
    }

    public LocalKeyId(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "LocalKeyId", objectArray);
            debug.exit(16384L, className, "LocalKeyId");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            LocalKeyId localKeyId = new LocalKeyId(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", localKeyId);
            }
            return localKeyId;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(16384L, className, "clone", exception);
                debug.exit(16384L, className, "clone");
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof LocalKeyId) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((LocalKeyId)object)));
            }
            return this.equals((LocalKeyId)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.LOCAL_KEY_ID_OID);
        }
        return PKCSOID.LOCAL_KEY_ID_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.keyId == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Local Key Identifier not specified.");
            }
            throw new IOException("Local Key Identifier not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        derOutputStream2.putOctetString(this.keyId);
        derOutputStream.write((byte)49, derOutputStream2.toByteArray());
        derOutputStream3.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, (Object)className, "encode", outputStream);
        }
    }

    public byte[] getLocalKeyId() {
        if (debug != null) {
            debug.entry(16384L, className, "getLocalKeyId");
            debug.exit(16384L, (Object)className, "getLocalKeyId", this.keyId.clone());
        }
        return (byte[])this.keyId.clone();
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getLocalKeyId());
        }
        return this.getLocalKeyId();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, className, "isTagValid");
        }
        if (by == 4) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingleValued", new Boolean(true));
        }
        return true;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "LocalKeyId");
        }
        return "LocalKeyId";
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        String string = "PKCS9 LocalKeyId:\r\n";
        string = this.keyId != null ? string + "\r\n" + hexDumpEncoder.encodeBuffer(this.keyId) + "\r\n" : string + "null";
        return string;
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.keyId = new DerInputStream(derValueArray[0].toByteArray()).getOctetString();
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(LocalKeyId localKeyId) {
        DerValue derValue;
        DerValue derValue2;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", localKeyId);
        }
        if (localKeyId == this) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(true));
            }
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode(derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            localKeyId.encode(derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exception(8192L, className, "equals", exception);
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (!derValue2.equals(derValue)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

