/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs9;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.PKCS12Utils;
import com.ibm.security.pkcs9.PKCS9DerObject;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.OutputStream;

public final class FriendlyName
extends PKCS9DerObject
implements Cloneable {
    private String name;
    private byte[] bmpName;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs9.FriendlyName";

    public FriendlyName(byte[] byArray) throws IOException {
        super(byArray);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "FriendlyName", (Object)byArray);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(byte[] byArray, String string) throws IOException {
        super(byArray, string);
        if (debug != null) {
            debug.entry(16384L, className, "FriendlyName", byArray, string);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(String string) {
        this.name = string;
        this.bmpName = PKCS12Utils.ascii2bmp(string.toCharArray());
        if (debug != null) {
            debug.entry(16384L, (Object)className, "FriendlyName", string);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(String string, String string2) {
        super(string2);
        this.name = string;
        this.bmpName = PKCS12Utils.ascii2bmp(string.toCharArray());
        if (debug != null) {
            debug.entry(16384L, className, "FriendlyName", string, string2);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(String string, boolean bl) throws IOException {
        super(string, bl);
        if (debug != null) {
            debug.entry(16384L, className, "FriendlyName", string, new Boolean(bl));
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public FriendlyName(String string, boolean bl, String string2) throws IOException {
        super(string, bl, string2);
        if (debug != null) {
            Object[] objectArray = new Object[]{string, new Boolean(bl), string2};
            debug.entry(16384L, (Object)className, "FriendlyName", objectArray);
            debug.exit(16384L, className, "FriendlyName");
        }
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, className, "clone");
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            this.encode(derOutputStream);
            FriendlyName friendlyName = new FriendlyName(derOutputStream.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone", friendlyName);
            }
            return friendlyName;
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.exit(16384L, className, "clone");
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", object);
        }
        if (object instanceof FriendlyName) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "equals", new Boolean(this.equals((FriendlyName)object)));
            }
            return this.equals((FriendlyName)object);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "equals", new Boolean(false));
        }
        return false;
    }

    public ObjectIdentifier getObjectIdentifier() {
        if (debug != null) {
            debug.entry(16384L, className, "getObjectIdentifier");
            debug.exit(16384L, (Object)className, "getObjectIdentifier", PKCSOID.FRIENDLY_NAME_OID);
        }
        return PKCSOID.FRIENDLY_NAME_OID;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", outputStream);
        }
        if (this.bmpName == null) {
            if (debug != null) {
                debug.text(16384L, className, "encode", "Friendly Name not specified.");
            }
            throw new IOException("Friendly Name not specified.");
        }
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        derOutputStream.putOID(this.getObjectIdentifier());
        derOutputStream2.putBMPString(this.bmpName);
        derOutputStream.write((byte)49, derOutputStream2.toByteArray());
        derOutputStream3.write((byte)48, derOutputStream.toByteArray());
        outputStream.write(derOutputStream3.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public String getFriendlyName() {
        if (debug != null) {
            debug.entry(16384L, className, "getFriendlyName");
        }
        try {
            if (this.name != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "getFriendlyName", this.name);
                }
                return this.name;
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "getFriendlyName", PKCS12Utils.bmp2string(this.bmpName));
            }
            return PKCS12Utils.bmp2string(this.bmpName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug != null) {
                debug.exception(16384L, className, "getFriendlyName", illegalArgumentException);
                debug.exit(16384L, (Object)className, "getFriendlyName", "Invalid Friendly Name");
            }
            return "Invalid Friendly Name";
        }
    }

    public Object getValue() {
        if (debug != null) {
            debug.entry(16384L, className, "getValue");
            debug.exit(16384L, (Object)className, "getValue", this.getFriendlyName());
        }
        return this.getFriendlyName();
    }

    public boolean isTagValid(byte by) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "isTagValid", new Byte(by));
        }
        if (by == 30) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "isTagValid", new Boolean(true));
            }
            return true;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "isTagValid", new Boolean(false));
        }
        return false;
    }

    public boolean isSingleValued() {
        if (debug != null) {
            debug.entry(16384L, className, "isSingleValued");
            debug.exit(16384L, (Object)className, "isSingeValued", new Boolean(true));
        }
        return true;
    }

    public String getAttributeName() {
        if (debug != null) {
            debug.entry(16384L, className, "getAttributeName");
            debug.exit(16384L, (Object)className, "getAttributeName", "FriendlyName");
        }
        return "FriendlyName";
    }

    public String toString() {
        String string = this.getFriendlyName();
        String string2 = "PKCS9 FriendlyName:\r\n";
        string2 = string2 + "\t" + string;
        return string2;
    }

    protected void decode(DerValue derValue) throws IOException {
        super.decode(derValue);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", derValue);
            debug.exit(16384L, className, "decode");
        }
        DerValue[] derValueArray = null;
        if (derValue.getTag() == 48) {
            DerInputStream derInputStream = new DerInputStream(derValue.toByteArray());
            DerValue[] derValueArray2 = derInputStream.getSequence(2);
            derValueArray = new DerInputStream(derValueArray2[1].toByteArray()).getSet(1);
        } else {
            derValueArray = new DerInputStream(derValue.toByteArray()).getSet(1);
        }
        this.bmpName = new DerInputStream(derValueArray[0].toByteArray()).getBMPString();
        try {
            this.name = PKCS12Utils.bmp2string(this.bmpName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (debug != null) {
                debug.exception(16384L, className, "decode", illegalArgumentException);
                debug.text(16384L, className, "decode", "Invalid BMP string");
            }
            throw new IOException("Invalid BMP string");
        }
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private boolean equals(FriendlyName friendlyName) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "equals", friendlyName);
        }
        if (this.bmpName.length != friendlyName.bmpName.length) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        for (int i = 0; i < this.bmpName.length; ++i) {
            if (this.bmpName[i] == friendlyName.bmpName[i]) continue;
            if (debug != null) {
                debug.exit(8192L, (Object)className, "equals", new Boolean(false));
            }
            return false;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "equals", new Boolean(true));
        }
        return true;
    }
}

